/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import dev.architectury.networking.NetworkManager;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithPosition;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class CasingInventoryMessage
extends AbstractMessageWithPosition {
    private int slot;
    private ItemStack stack;
    private CompoundTag moduleData;

    public CasingInventoryMessage(Casing casing, int slot, ItemStack stack, @Nullable CompoundTag moduleData) {
        super(casing.getPosition());
        this.slot = slot;
        this.stack = stack;
        this.moduleData = moduleData;
    }

    public CasingInventoryMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void handleMessage(NetworkManager.PacketContext context) {
        Level level = this.getClientLevel();
        if (level != null) {
            this.withBlockEntity(level, CasingBlockEntity.class, casing -> casing.setStackAndModuleClient(this.slot, this.stack, this.moduleData));
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        this.slot = buffer.readUnsignedByte();
        this.stack = buffer.m_130267_();
        this.moduleData = buffer.m_130260_();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeByte(this.slot);
        buffer.m_130055_(this.stack);
        buffer.m_130079_(this.moduleData);
    }
}

