/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import dev.architectury.networking.NetworkManager;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithPosition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public final class CasingLockedStateMessage
extends AbstractMessageWithPosition {
    private boolean isLocked;

    public CasingLockedStateMessage(Casing casing, boolean isLocked) {
        super(casing.getPosition());
        this.isLocked = isLocked;
    }

    public CasingLockedStateMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void handleMessage(NetworkManager.PacketContext context) {
        Level level = this.getClientLevel();
        if (level != null) {
            this.withBlockEntity(level, CasingBlockEntity.class, casing -> casing.setCasingLockedClient(this.isLocked));
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        this.isLocked = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeBoolean(this.isLocked);
    }
}

