/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.network.message;

import dev.architectury.networking.NetworkManager;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.machine.Port;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.network.message.AbstractMessageWithPosition;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;

public final class ReceivingPipeLockedStateMessage
extends AbstractMessageWithPosition {
    private Face face;
    private Port port;
    private boolean isLocked;

    public ReceivingPipeLockedStateMessage(Casing casing, Face face, Port port, boolean isLocked) {
        super(casing.getPosition());
        this.face = face;
        this.port = port;
        this.isLocked = isLocked;
    }

    public ReceivingPipeLockedStateMessage(FriendlyByteBuf buffer) {
        super(buffer);
    }

    @Override
    public void handleMessage(NetworkManager.PacketContext context) {
        Level level = this.getClientLevel();
        if (level != null) {
            this.withBlockEntity(level, CasingBlockEntity.class, casing -> casing.setReceivingPipeLockedClient(this.face, this.port, this.isLocked));
        }
    }

    @Override
    public void fromBytes(FriendlyByteBuf buffer) {
        super.fromBytes(buffer);
        byte compressed = buffer.readByte();
        this.face = Face.VALUES[compressed >>> 3 & 7];
        this.port = Port.VALUES[compressed >>> 1 & 3];
        this.isLocked = (compressed & 1) == 1;
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        byte compressed = (byte)(this.face.ordinal() << 3 | this.port.ordinal() << 1 | (this.isLocked ? 1 : 0));
        buffer.writeByte((int)compressed);
    }
}

