/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.provider;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import li.cil.tis3d.api.machine.Casing;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.ModuleProvider;
import li.cil.tis3d.common.item.Items;
import li.cil.tis3d.common.item.ModuleItem;
import li.cil.tis3d.common.module.AudioModule;
import li.cil.tis3d.common.module.DisplayModule;
import li.cil.tis3d.common.module.ExecutionModule;
import li.cil.tis3d.common.module.FacadeModule;
import li.cil.tis3d.common.module.InfraredModule;
import li.cil.tis3d.common.module.KeypadModule;
import li.cil.tis3d.common.module.QueueModule;
import li.cil.tis3d.common.module.RandomAccessMemoryModule;
import li.cil.tis3d.common.module.RandomModule;
import li.cil.tis3d.common.module.ReadOnlyMemoryModule;
import li.cil.tis3d.common.module.RedstoneModule;
import li.cil.tis3d.common.module.SequencerModule;
import li.cil.tis3d.common.module.SerialPortModule;
import li.cil.tis3d.common.module.StackModule;
import li.cil.tis3d.common.module.TerminalModule;
import li.cil.tis3d.common.module.TimerModule;
import li.cil.tis3d.common.provider.module.SimpleModuleProvider;
import li.cil.tis3d.util.RegistryUtils;
import net.minecraft.world.item.ItemStack;

public final class ModuleProviders {
    private static final DeferredRegister<ModuleProvider> MODULE_PROVIDERS = RegistryUtils.get(ModuleProvider.REGISTRY);
    private static final Supplier<Registrar<ModuleProvider>> REGISTRAR = Suppliers.memoize(() -> Registries.get((String)"tis3d").get(ModuleProvider.REGISTRY));

    public static void initialize() {
        RegistryUtils.builder(ModuleProvider.REGISTRY, new ModuleProvider[0]).build();
        ModuleProviders.register(Items.AUDIO_MODULE, AudioModule::new);
        ModuleProviders.register(Items.DISPLAY_MODULE, DisplayModule::new);
        ModuleProviders.register(Items.EXECUTION_MODULE, ExecutionModule::new);
        ModuleProviders.register(Items.FACADE_MODULE, FacadeModule::new);
        ModuleProviders.register(Items.INFRARED_MODULE, InfraredModule::new);
        ModuleProviders.register(Items.KEYPAD_MODULE, KeypadModule::new);
        ModuleProviders.register(Items.QUEUE_MODULE, QueueModule::new);
        ModuleProviders.register(Items.RANDOM_MODULE, RandomModule::new);
        ModuleProviders.register(Items.RANDOM_ACCESS_MEMORY_MODULE, RandomAccessMemoryModule::new);
        ModuleProviders.register(Items.READ_ONLY_MEMORY_MODULE, ReadOnlyMemoryModule::new);
        ModuleProviders.register(Items.REDSTONE_MODULE, RedstoneModule::new);
        ModuleProviders.register(Items.SEQUENCER_MODULE, SequencerModule::new);
        ModuleProviders.register(Items.SERIAL_PORT_MODULE, SerialPortModule::new);
        ModuleProviders.register(Items.STACK_MODULE, StackModule::new);
        ModuleProviders.register(Items.TERMINAL_MODULE, TerminalModule::new);
        ModuleProviders.register(Items.TIMER_MODULE, TimerModule::new);
        MODULE_PROVIDERS.register();
    }

    public static Optional<ModuleProvider> getProviderFor(ItemStack stack, Casing casing, Face face) {
        for (ModuleProvider provider : REGISTRAR.get()) {
            if (!provider.matches(stack, casing, face)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }

    private static <T extends Module> void register(RegistrySupplier<? extends ModuleItem> item, BiFunction<Casing, Face, T> factory) {
        MODULE_PROVIDERS.register(item.getId().m_135815_(), () -> new SimpleModuleProvider(item, factory));
    }
}

