/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.provider;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import java.util.function.Supplier;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.RedstoneInputProvider;
import li.cil.tis3d.common.provider.redstone.MinecraftRedstoneInputProvider;
import li.cil.tis3d.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public final class RedstoneInputProviders {
    private static final DeferredRegister<RedstoneInputProvider> REDSTONE_INPUT_PROVIDERS = RegistryUtils.get(RedstoneInputProvider.REGISTRY);
    private static final Supplier<Registrar<RedstoneInputProvider>> REGISTRAR = Suppliers.memoize(() -> Registries.get((String)"tis3d").get(RedstoneInputProvider.REGISTRY));

    public static void initialize() {
        RegistryUtils.builder(RedstoneInputProvider.REGISTRY, new RedstoneInputProvider[0]).build();
        REDSTONE_INPUT_PROVIDERS.register("minecraft", MinecraftRedstoneInputProvider::new);
        REDSTONE_INPUT_PROVIDERS.register();
    }

    public static int getRedstoneInput(Module module) {
        int maxSignal = 0;
        Level level = module.getCasing().getCasingLevel();
        BlockPos position = module.getCasing().getPosition();
        for (RedstoneInputProvider provider : REGISTRAR.get()) {
            int signal = provider.getInput(level, position, Face.toDirection(module.getFace()));
            if (signal <= maxSignal) continue;
            maxSignal = signal;
        }
        return maxSignal;
    }
}

