/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.provider;

import com.google.common.base.Suppliers;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import java.util.Optional;
import java.util.function.Supplier;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.common.provider.serial.SerialInterfaceProviderFurnace;
import li.cil.tis3d.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public final class SerialInterfaceProviders {
    private static final DeferredRegister<SerialInterfaceProvider> MODULE_PROVIDERS = RegistryUtils.get(SerialInterfaceProvider.REGISTRY);
    public static final Supplier<Registrar<SerialInterfaceProvider>> REGISTRAR = Suppliers.memoize(() -> Registries.get((String)"tis3d").get(SerialInterfaceProvider.REGISTRY));

    public static void initialize() {
        RegistryUtils.builder(SerialInterfaceProvider.REGISTRY, new SerialInterfaceProvider[0]).build();
        MODULE_PROVIDERS.register("furnace", SerialInterfaceProviderFurnace::new);
        MODULE_PROVIDERS.register();
    }

    public static Optional<SerialInterfaceProvider> getProviderFor(Level level, BlockPos position, Direction face) {
        for (SerialInterfaceProvider provider : REGISTRAR.get()) {
            if (!provider.matches(level, position, face)) continue;
            return Optional.of(provider);
        }
        return Optional.empty();
    }
}

