/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.common.provider.serial;

import java.util.Objects;
import java.util.Optional;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import li.cil.tis3d.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;

public final class SerialInterfaceProviderFurnace
implements SerialInterfaceProvider {
    private static final Component DOCUMENTATION_TITLE = Component.m_237115_((String)"tis3d.manual.serial_protocols.furnace");
    private static final String DOCUMENTATION_LINK = "minecraft_furnace.md";
    private static final SerialProtocolDocumentationReference DOCUMENTATION_REFERENCE = new SerialProtocolDocumentationReference(DOCUMENTATION_TITLE, "minecraft_furnace.md");

    @Override
    public boolean matches(Level level, BlockPos position, Direction side) {
        return level.m_7702_(position) instanceof FurnaceBlockEntity;
    }

    @Override
    public Optional<SerialInterface> getInterface(Level level, BlockPos position, Direction face) {
        FurnaceBlockEntity furnace = Objects.requireNonNull((FurnaceBlockEntity)level.m_7702_(position));
        return Optional.of(new SerialInterfaceFurnace(furnace));
    }

    @Override
    public Optional<SerialProtocolDocumentationReference> getDocumentationReference() {
        return Optional.of(DOCUMENTATION_REFERENCE);
    }

    @Override
    public boolean stillValid(Level level, BlockPos position, Direction side, SerialInterface serialInterface) {
        return serialInterface instanceof SerialInterfaceFurnace;
    }

    private static final class SerialInterfaceFurnace
    implements SerialInterface {
        private static final String TAG_MODE = "mode";
        private final FurnaceBlockEntity furnace;
        private Mode mode = Mode.PercentageFuel;

        SerialInterfaceFurnace(FurnaceBlockEntity furnace) {
            this.furnace = furnace;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public void write(short value) {
            this.mode = value == 0 ? Mode.PercentageFuel : Mode.PercentageProgress;
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public short peek() {
            switch (this.mode) {
                case PercentageFuel: {
                    int value = this.furnace.f_58316_;
                    int total = this.furnace.f_58317_;
                    if (total > 0) {
                        return (short)(value * 100 / total);
                    }
                }
                case PercentageProgress: {
                    int value = this.furnace.f_58318_;
                    int total = this.furnace.f_58319_;
                    if (total <= 0) break;
                    return (short)(value * 100 / total);
                }
            }
            return 0;
        }

        @Override
        public void skip() {
        }

        @Override
        public void reset() {
            this.mode = Mode.PercentageFuel;
        }

        @Override
        public void load(CompoundTag tag) {
            this.mode = EnumUtils.load(Mode.class, TAG_MODE, tag);
        }

        @Override
        public void save(CompoundTag tag) {
            EnumUtils.save(this.mode, TAG_MODE, tag);
        }

        private static enum Mode {
            PercentageFuel,
            PercentageProgress;

        }
    }
}

