/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.data.forge;

import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.common.block.Blocks;
import li.cil.tis3d.common.block.CasingBlock;
import li.cil.tis3d.common.item.Items;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public final class ModBlockStateProvider
extends BlockStateProvider {
    private static final ResourceLocation FULL_CASING_MODEL = new ResourceLocation("tis3d", "block/casing_all");
    private static final ResourceLocation EMPTY_CASING_MODEL = new ResourceLocation("tis3d", "block/casing_empty");
    private static final ResourceLocation MODULE_IN_CASING_MODEL = new ResourceLocation("tis3d", "block/casing_module");
    private static final ResourceLocation CONTROLLER_MODEL = new ResourceLocation("tis3d", "block/controller");

    public ModBlockStateProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "tis3d", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelFile.ExistingModelFile casingAll = this.models().getExistingFile(FULL_CASING_MODEL);
        ModelFile.ExistingModelFile casingEmpty = this.models().getExistingFile(EMPTY_CASING_MODEL);
        ModelFile.ExistingModelFile casingModule = this.models().getExistingFile(MODULE_IN_CASING_MODEL);
        MultiPartBlockStateBuilder casingBuilder = this.getMultipartBuilder((Block)Blocks.CASING.get());
        CasingBlock.FACE_TO_PROPERTY.forEach((face, property) -> {
            Direction direction = Face.toDirection(face);
            int rotationY = (int)direction.m_122435_();
            int rotationX = direction == Direction.UP ? 90 : (direction == Direction.DOWN ? -90 : 0);
            ((MultiPartBlockStateBuilder.PartBuilder)casingBuilder.part().modelFile((ModelFile)casingEmpty).rotationX(rotationX).rotationY(rotationY).addModel()).condition((Property)property, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)casingBuilder.part().modelFile((ModelFile)casingModule).rotationX(rotationX).rotationY(rotationY).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true}).end();
        });
        ((ItemModelBuilder)this.itemModels().getBuilder(Items.CASING.getId().m_135815_())).parent((ModelFile)casingAll);
        this.simpleBlock((Block)Blocks.CONTROLLER.get(), (ModelFile)this.models().getExistingFile(CONTROLLER_MODEL));
        ((ItemModelBuilder)this.itemModels().getBuilder(Items.CONTROLLER.getId().m_135815_())).parent((ModelFile)this.models().getExistingFile(Blocks.CONTROLLER.getId()));
    }
}

