/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.data.forge;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import li.cil.tis3d.common.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.registries.ForgeRegistries;

public final class ModLootTableProvider
extends LootTableProvider {
    public ModLootTableProvider(DataGenerator generator) {
        super(generator);
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        Set modLootTableIds = BuiltInLootTables.m_78766_().stream().filter(lootTable -> Objects.equals(lootTable.m_135827_(), "tis3d")).collect(Collectors.toSet());
        for (ResourceLocation id : Sets.difference(modLootTableIds, map.keySet())) {
            validationContext.m_79357_("Missing mod loot table: " + id);
        }
        map.forEach((location, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)location, (LootTable)table));
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return Collections.singletonList(Pair.of(ModBlockLootTables::new, (Object)LootContextParamSets.f_81421_));
    }

    public static final class ModBlockLootTables
    extends BlockLoot {
        protected void addTables() {
            this.m_124288_((Block)Blocks.CASING.get());
            this.m_124288_((Block)Blocks.CONTROLLER.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            return StreamSupport.stream(super.getKnownBlocks().spliterator(), false).filter(block -> {
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey(block);
                return blockId != null && Objects.equals(blockId.m_135827_(), "tis3d");
            }).collect(Collectors.toSet());
        }
    }
}

