/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.mixin.forge;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.tis3d.api.machine.Face;
import li.cil.tis3d.api.module.Module;
import li.cil.tis3d.api.module.traits.forge.ModuleWithBakedModelForge;
import li.cil.tis3d.client.renderer.block.forge.ModuleBakedModel;
import li.cil.tis3d.common.block.entity.CasingBlockEntity;
import li.cil.tis3d.common.machine.CasingImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CasingBlockEntity.class})
public abstract class MixinCasingBlockEntity
extends BlockEntity {
    @Shadow(remap=false)
    private CasingImpl casing;

    private MixinCasingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private CasingBlockEntity asCasingBlockEntity() {
        return (CasingBlockEntity)((Object)this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.asCasingBlockEntity().dispose();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        LazyOptional instance = super.getCapability(capability, facing);
        if (instance.isPresent()) {
            return instance;
        }
        if (facing == null) {
            return LazyOptional.empty();
        }
        Module module = this.asCasingBlockEntity().getModule(Face.fromDirection(facing));
        if (module instanceof ICapabilityProvider) {
            ICapabilityProvider capabilityProvider = (ICapabilityProvider)module;
            return capabilityProvider.getCapability(capability, facing);
        }
        return LazyOptional.empty();
    }

    @NotNull
    public ModelData getModelData() {
        ModelData modelData = super.getModelData();
        if (this.f_58857_ == null) {
            return modelData;
        }
        ModuleBakedModel.CasingModules data = new ModuleBakedModel.CasingModules();
        for (Face face : Face.VALUES) {
            ModuleWithBakedModelForge moduleWithModel;
            Module module = this.casing.getModule(face);
            if (!(module instanceof ModuleWithBakedModelForge) || !(moduleWithModel = (ModuleWithBakedModelForge)((Object)module)).hasModel()) continue;
            data.setModule(face, moduleWithModel, moduleWithModel.getModelData((BlockAndTintGetter)this.f_58857_, this.m_58899_(), this.m_58900_(), modelData));
        }
        if (!data.isEmpty()) {
            return ModelData.builder().with(ModuleBakedModel.CasingModules.CASING_MODULES_PROPERTY, (Object)data).build();
        }
        return modelData;
    }
}

