/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

public final class Color {
    public static final int WHITE = -1;
    public static final int ORANGE = -13261;
    public static final int MAGENTA = -3381556;
    public static final int LIGHT_BLUE = -10053121;
    public static final int YELLOW = -205;
    public static final int LIME = -13382605;
    public static final int PINK = -39271;
    public static final int GRAY = -13421773;
    public static final int LIGHT_GRAY = -3355444;
    public static final int CYAN = -13408615;
    public static final int PURPLE = -6736948;
    public static final int BLUE = -13421671;
    public static final int BROWN = -10079488;
    public static final int GREEN = -13408768;
    public static final int RED = -52429;
    public static final int BLACK = -16777216;
    public static final int DARK_GRAY = -15658735;
    public static final int GUI_TEXT = -12566464;
    private static final int[] COLORS = new int[]{-1, -13261, -3381556, -10053121, -205, -13382605, -39271, -13421773, -3355444, -13408615, -6736948, -13421671, -10079488, -13408768, -52429, -16777216};

    public static int getColorByIndex(int index) {
        return COLORS[index % COLORS.length];
    }

    public static int withAlpha(int color, float alpha) {
        return (int)(Math.max(0.0f, Math.min(1.0f, alpha)) * 255.0f) << 24 | color & 0xFFFFFF;
    }

    public static int monochrome(float brightness) {
        int component = (int)(Math.max(0.0f, Math.min(1.0f, brightness)) * 255.0f);
        return 0xFF000000 | component << 16 | component << 8 | component;
    }

    public static int getAlphaU8(int color) {
        return color >>> 24 & 0xFF;
    }

    public static int getRedU8(int color) {
        return color >>> 16 & 0xFF;
    }

    public static int getGreenU8(int color) {
        return color >>> 8 & 0xFF;
    }

    public static int getBlueU8(int color) {
        return color & 0xFF;
    }

    private Color() {
    }
}

