/*
 * Decompiled with CFR 0.152.
 */
package li.cil.tis3d.util;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Raytracing {
    @Nullable
    public static HitResult intersectIgnoringTransparent(Level level, BlockPos position, Vec3 start, Vec3 end) {
        VoxelShape shape;
        BlockState state = level.m_8055_(position);
        if (state.m_60804_((BlockGetter)level, position) && !(shape = state.m_60768_((BlockGetter)level, position)).m_83281_()) {
            return shape.m_83220_(start, end, position);
        }
        return null;
    }

    @Nullable
    public static HitResult raytrace(Level level, Vec3 start, Vec3 end, CollisionDetector callback) {
        int startPosX = Mth.m_14107_((double)start.f_82479_);
        int startPosY = Mth.m_14107_((double)start.f_82480_);
        int startPosZ = Mth.m_14107_((double)start.f_82481_);
        int endPosX = Mth.m_14107_((double)end.f_82479_);
        int endPosY = Mth.m_14107_((double)end.f_82480_);
        int endPosZ = Mth.m_14107_((double)end.f_82481_);
        int stepX = Integer.compare(endPosX, startPosX);
        int stepY = Integer.compare(endPosY, startPosY);
        int stepZ = Integer.compare(endPosZ, startPosZ);
        int gxp = startPosX + (endPosX > startPosX ? 1 : 0);
        int gyp = startPosY + (endPosY > startPosY ? 1 : 0);
        int gzp = startPosZ + (endPosZ > startPosZ ? 1 : 0);
        double vx = end.f_82479_ == start.f_82479_ ? 1.0 : end.f_82479_ - start.f_82479_;
        double vy = end.f_82480_ == start.f_82480_ ? 1.0 : end.f_82480_ - start.f_82480_;
        double vz = end.f_82481_ == start.f_82481_ ? 1.0 : end.f_82481_ - start.f_82481_;
        double vxvy = vx * vy;
        double vxvz = vx * vz;
        double vyvz = vy * vz;
        double scaledErrorX = (double)stepX * vyvz;
        double scaledErrorY = (double)stepY * vxvz;
        double scaledErrorZ = (double)stepZ * vxvy;
        double errorX = ((double)gxp - start.f_82479_) * vyvz;
        double errorY = ((double)gyp - start.f_82480_) * vxvz;
        double errorZ = ((double)gzp - start.f_82481_) * vxvy;
        int currentPosX = startPosX;
        int currentPosY = startPosY;
        int currentPosZ = startPosZ;
        int emergencyExit = 200;
        while (--emergencyExit > 0) {
            BlockPos position = new BlockPos(currentPosX, currentPosY, currentPosZ);
            HitResult hit = callback.intersect(level, position, start, end);
            if (hit != null && hit.m_6662_() != HitResult.Type.MISS) {
                return hit;
            }
            if (currentPosX == endPosX && currentPosY == endPosY && currentPosZ == endPosZ) {
                return null;
            }
            double xr = Math.abs(errorX);
            double yr = Math.abs(errorY);
            double zr = Math.abs(errorZ);
            if (stepX != 0 && (stepY == 0 || xr < yr) && (stepZ == 0 || xr < zr)) {
                currentPosX += stepX;
                errorX += scaledErrorX;
                continue;
            }
            if (stepY != 0 && (stepZ == 0 || yr < zr)) {
                currentPosY += stepY;
                errorY += scaledErrorY;
                continue;
            }
            if (stepZ == 0) continue;
            currentPosZ += stepZ;
            errorZ += scaledErrorZ;
        }
        return null;
    }

    private Raytracing() {
    }

    @FunctionalInterface
    public static interface CollisionDetector {
        @Nullable
        public HitResult intersect(Level var1, BlockPos var2, Vec3 var3, Vec3 var4);
    }
}

