/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;
import twilightforest.enums.Diagonals;

public class SpiralBrickBlock
extends Block {
    public static final EnumProperty<Diagonals> DIAGONAL = EnumProperty.m_61587_((String)"diagonal", Diagonals.class);
    public static final EnumProperty<Direction.Axis> AXIS_FACING = EnumProperty.m_61587_((String)"axis", Direction.Axis.class);

    public SpiralBrickBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60999_().m_60913_(1.5f, 10.0f).m_60918_(SoundType.f_56742_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(DIAGONAL, (Comparable)((Object)Diagonals.BOTTOM_RIGHT))).m_61124_(AXIS_FACING, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AXIS_FACING, DIAGONAL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_7078_()) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS_FACING, (Comparable)Direction.Axis.Y)).m_61124_(DIAGONAL, (Comparable)((Object)SpiralBrickBlock.convertVerticalDirectionToDiagonal(context.m_8125_())));
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS_FACING, (Comparable)(context.m_8125_().m_122434_() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).m_61124_(DIAGONAL, (Comparable)((Object)SpiralBrickBlock.getHorizontalDiagonalFromPlayerPlacement((LivingEntity)context.m_43723_(), context.m_8125_(), context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() > 0.5)));
    }

    private static Diagonals convertVerticalDirectionToDiagonal(Direction facing) {
        return switch (facing) {
            default -> Diagonals.TOP_RIGHT;
            case Direction.SOUTH -> Diagonals.BOTTOM_LEFT;
            case Direction.EAST -> Diagonals.TOP_LEFT;
            case Direction.WEST -> Diagonals.BOTTOM_RIGHT;
        };
    }

    private static Diagonals getHorizontalDiagonalFromPlayerPlacement(LivingEntity placer, Direction facing, boolean upper) {
        return switch (facing) {
            case Direction.EAST, Direction.NORTH -> Diagonals.getDiagonalFromUpDownLeftRight(placer.m_6350_() != facing, upper);
            case Direction.SOUTH, Direction.WEST -> Diagonals.getDiagonalFromUpDownLeftRight(placer.m_6350_() == facing, upper);
            default -> Diagonals.BOTTOM_RIGHT;
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS_FACING);
        if (axis == Direction.Axis.Y) {
            return (BlockState)state.m_61124_(DIAGONAL, (Comparable)((Object)Diagonals.rotate((Diagonals)((Object)state.m_61143_(DIAGONAL)), rot)));
        }
        if (rot == Rotation.CLOCKWISE_180 || axis == Direction.Axis.X && rot == Rotation.COUNTERCLOCKWISE_90 || axis == Direction.Axis.Z && rot == Rotation.CLOCKWISE_90) {
            state = (BlockState)state.m_61124_(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.m_61143_(DIAGONAL)), Mirror.LEFT_RIGHT)));
        }
        return rot.ordinal() % 2 == 0 ? state : (BlockState)state.m_61124_(AXIS_FACING, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_(DIAGONAL, (Comparable)((Object)Diagonals.mirrorOn((Direction.Axis)state.m_61143_(AXIS_FACING), (Diagonals)((Object)state.m_61143_(DIAGONAL)), mirror)));
    }
}

