/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.TFConfig;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFSounds;

public class CicadaBlockEntity
extends BlockEntity {
    private int yawDelay;
    public int currentYaw;
    private int desiredYaw;
    private int singDuration;
    private boolean singing;
    private int singDelay;
    public float randRot = (float)RandomSource.m_216327_().m_188503_(4) * 90.0f;

    public CicadaBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.CICADA.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CicadaBlockEntity te) {
        if (level.m_5776_()) {
            if (te.yawDelay > 0) {
                --te.yawDelay;
            } else {
                if (te.currentYaw == 0 && te.desiredYaw == 0) {
                    te.yawDelay = 200 + level.m_213780_().m_188503_(200);
                    te.desiredYaw = level.m_213780_().m_188503_(15) - level.m_213780_().m_188503_(15);
                }
                if (te.currentYaw < te.desiredYaw) {
                    ++te.currentYaw;
                }
                if (te.currentYaw > te.desiredYaw) {
                    --te.currentYaw;
                }
                if (te.currentYaw == te.desiredYaw) {
                    te.desiredYaw = 0;
                }
            }
            if (te.singDelay > 0) {
                --te.singDelay;
            } else {
                if (te.singing && te.singDuration == 0) {
                    te.playSong();
                }
                if (te.singing && te.singDuration >= 100) {
                    te.singing = false;
                    te.singDuration = 0;
                }
                if (te.singing && te.singDuration < 100) {
                    ++te.singDuration;
                    te.doSingAnimation();
                }
                if (!te.singing && te.singDuration <= 0) {
                    te.singing = true;
                    te.singDelay = 100 + level.m_213780_().m_188503_(100);
                }
            }
        }
    }

    private void doSingAnimation() {
        if (this.m_58904_().m_213780_().m_188503_(5) == 0) {
            double rx = (float)this.m_58899_().m_123341_() + this.m_58904_().m_213780_().m_188501_();
            double ry = (float)this.m_58899_().m_123342_() + this.m_58904_().m_213780_().m_188501_();
            double rz = (float)this.m_58899_().m_123343_() + this.m_58904_().m_213780_().m_188501_();
            this.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123758_, rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    private void playSong() {
        if (!((Boolean)TFConfig.CLIENT_CONFIG.silentCicadas.get()).booleanValue()) {
            this.m_58904_().m_7785_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (SoundEvent)TFSounds.CICADA.get(), SoundSource.NEUTRAL, 1.0f, (this.m_58904_().m_213780_().m_188501_() - this.m_58904_().m_213780_().m_188501_()) * 0.2f + 1.0f, false);
        }
    }
}

