/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TrophyBlock;
import twilightforest.block.TrophyWallBlock;
import twilightforest.block.entity.TrophyBlockEntity;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.tileentity.AlphaYetiTrophyModel;
import twilightforest.client.model.tileentity.GenericTrophyModel;
import twilightforest.client.model.tileentity.HydraTrophyModel;
import twilightforest.client.model.tileentity.KnightPhantomTrophyModel;
import twilightforest.client.model.tileentity.LichTrophyModel;
import twilightforest.client.model.tileentity.MinoshroomTrophyModel;
import twilightforest.client.model.tileentity.NagaTrophyModel;
import twilightforest.client.model.tileentity.QuestRamTrophyModel;
import twilightforest.client.model.tileentity.SnowQueenTrophyModel;
import twilightforest.client.model.tileentity.UrGhastTrophyModel;
import twilightforest.client.model.tileentity.legacy.HydraTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.MinoshroomTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.QuestRamTrophyLegacyModel;
import twilightforest.client.model.tileentity.legacy.SnowQueenTrophyLegacyModel;
import twilightforest.enums.BossVariant;
import twilightforest.init.TFBlocks;

public class TrophyTileEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    private final Map<BossVariant, GenericTrophyModel> trophies;
    private static final ResourceLocation textureLocHydra = TwilightForestMod.getModelTexture("hydra4.png");
    private static final ResourceLocation textureLocNaga = TwilightForestMod.getModelTexture("nagahead.png");
    private static final ResourceLocation textureLocLich = TwilightForestMod.getModelTexture("twilightlich64.png");
    private static final ResourceLocation textureLocUrGhast = TwilightForestMod.getModelTexture("towerboss.png");
    private static final ResourceLocation textureLocSnowQueen = TwilightForestMod.getModelTexture("snowqueen.png");
    private static final ResourceLocation textureLocMinoshroom = TwilightForestMod.getModelTexture("minoshroomtaur.png");
    private static final ResourceLocation textureLocKnightPhantom = TwilightForestMod.getModelTexture("phantomskeleton.png");
    private static final ResourceLocation textureLocKnightPhantomArmor = new ResourceLocation("twilightforest:textures/armor/phantom_1.png");
    private static final ResourceLocation textureLocYeti = TwilightForestMod.getModelTexture("yetialpha.png");
    private static final ResourceLocation textureLocQuestRam = TwilightForestMod.getModelTexture("questram.png");
    private static final ResourceLocation textureLocQuestRamLines = TwilightForestMod.getModelTexture("questram_lines.png");
    public static ItemStack stack = new ItemStack((ItemLike)TFBlocks.NAGA_TROPHY.get());

    public TrophyTileEntityRenderer(BlockEntityRendererProvider.Context renderer) {
        this.trophies = TrophyTileEntityRenderer.createTrophyRenderers(renderer.m_173585_());
    }

    public static Map<BossVariant, GenericTrophyModel> createTrophyRenderers(EntityModelSet set) {
        BooleanSupplier legacy = () -> Minecraft.m_91087_().m_91099_().m_10523_().contains("builtin/twilight_forest_legacy_resources");
        ImmutableMap.Builder trophyList = ImmutableMap.builder();
        trophyList.put((Object)BossVariant.NAGA, (Object)new NagaTrophyModel(set.m_171103_(TFModelLayers.NAGA_TROPHY)));
        trophyList.put((Object)BossVariant.LICH, (Object)new LichTrophyModel(set.m_171103_(TFModelLayers.LICH_TROPHY)));
        trophyList.put((Object)BossVariant.MINOSHROOM, (Object)(legacy.getAsBoolean() ? new MinoshroomTrophyLegacyModel(set.m_171103_(TFModelLayers.LEGACY_MINOSHROOM_TROPHY)) : new MinoshroomTrophyModel(set.m_171103_(TFModelLayers.MINOSHROOM_TROPHY))));
        trophyList.put((Object)BossVariant.HYDRA, (Object)(legacy.getAsBoolean() ? new HydraTrophyLegacyModel(set.m_171103_(TFModelLayers.LEGACY_HYDRA_TROPHY)) : new HydraTrophyModel(set.m_171103_(TFModelLayers.HYDRA_TROPHY))));
        trophyList.put((Object)BossVariant.KNIGHT_PHANTOM, (Object)new KnightPhantomTrophyModel(set.m_171103_(TFModelLayers.KNIGHT_PHANTOM_TROPHY)));
        trophyList.put((Object)BossVariant.UR_GHAST, (Object)new UrGhastTrophyModel(set.m_171103_(TFModelLayers.UR_GHAST_TROPHY)));
        trophyList.put((Object)BossVariant.ALPHA_YETI, (Object)new AlphaYetiTrophyModel(set.m_171103_(TFModelLayers.ALPHA_YETI_TROPHY)));
        trophyList.put((Object)BossVariant.SNOW_QUEEN, (Object)(legacy.getAsBoolean() ? new SnowQueenTrophyLegacyModel(set.m_171103_(TFModelLayers.LEGACY_SNOW_QUEEN_TROPHY)) : new SnowQueenTrophyModel(set.m_171103_(TFModelLayers.SNOW_QUEEN_TROPHY))));
        trophyList.put((Object)BossVariant.QUEST_RAM, (Object)(legacy.getAsBoolean() ? new QuestRamTrophyLegacyModel(set.m_171103_(TFModelLayers.LEGACY_QUEST_RAM_TROPHY)) : new QuestRamTrophyModel(set.m_171103_(TFModelLayers.QUEST_RAM_TROPHY))));
        return trophyList.build();
    }

    public void render(TrophyBlockEntity tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f = tileEntityIn.getAnimationProgress(partialTicks);
        BlockState blockstate = tileEntityIn.m_58900_();
        boolean flag = blockstate.m_60734_() instanceof TrophyWallBlock;
        Direction direction = flag ? (Direction)blockstate.m_61143_((Property)TrophyWallBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.m_122416_()) * 4 : (Integer)blockstate.m_61143_((Property)TrophyBlock.ROTATION));
        BossVariant variant = ((AbstractTrophyBlock)blockstate.m_60734_()).getVariant();
        GenericTrophyModel trophy = this.trophies.get((Object)variant);
        matrixStackIn.m_85836_();
        if (variant == BossVariant.HYDRA) {
            trophy.openMouthForTrophy(flag ? 0.5f : 0.0f);
        }
        if (variant == BossVariant.UR_GHAST) {
            ((UrGhastTrophyModel)trophy).setTranslate(matrixStackIn, 0.0f, 1.0f, 0.0f);
        }
        TrophyTileEntityRenderer.render(direction, f1, trophy, variant, f, matrixStackIn, bufferIn, combinedLightIn, ItemTransforms.TransformType.NONE);
        matrixStackIn.m_85849_();
    }

    public static void render(@Nullable Direction directionIn, float y, GenericTrophyModel trophy, BossVariant variant, float animationProgress, PoseStack matrixStackIn, MultiBufferSource buffer, int combinedLight, ItemTransforms.TransformType camera) {
        BooleanSupplier legacy = () -> Minecraft.m_91087_().m_91099_().m_10523_().contains("builtin/twilight_forest_legacy_resources");
        matrixStackIn.m_85836_();
        if (directionIn == null || variant == BossVariant.UR_GHAST) {
            matrixStackIn.m_85837_(0.5, 0.01, 0.5);
        } else {
            matrixStackIn.m_85837_((double)(0.5f - (float)directionIn.m_122429_() * 0.249f), 0.25, (double)(0.5f - (float)directionIn.m_122431_() * 0.249f));
        }
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        switch (variant) {
            case HYDRA: {
                matrixStackIn.m_85841_(0.25f, 0.25f, 0.25f);
                if (camera == ItemTransforms.TransformType.GUI) {
                    trophy.openMouthForTrophy(0.35f);
                }
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(legacy.getAsBoolean() ? 1.0 : 0.0, legacy.getAsBoolean() ? (double)-1.15f : -1.0, 0.0);
                VertexConsumer hydraVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocHydra));
                trophy.m_7695_(matrixStackIn, hydraVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NAGA: {
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(0.0, 0.25, 0.0);
                VertexConsumer nagaVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocNaga));
                trophy.m_7695_(matrixStackIn, nagaVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case LICH: {
                matrixStackIn.m_85837_(0.0, 0.25, 0.0);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                VertexConsumer lichVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocLich));
                trophy.m_7695_(matrixStackIn, lichVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UR_GHAST: {
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                VertexConsumer ghastVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocUrGhast));
                trophy.m_7695_(matrixStackIn, ghastVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SNOW_QUEEN: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(0.0, legacy.getAsBoolean() ? 0.25 : 0.0, 0.0);
                VertexConsumer waifuVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocSnowQueen));
                trophy.m_7695_(matrixStackIn, waifuVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case MINOSHROOM: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(0.0, legacy.getAsBoolean() ? (double)0.12f : (double)0.065f, legacy.getAsBoolean() ? (double)0.56f : 0.0);
                VertexConsumer minoVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocMinoshroom));
                trophy.m_7695_(matrixStackIn, minoVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case KNIGHT_PHANTOM: {
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(0.0, 0.25, 0.0);
                VertexConsumer phantomVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocKnightPhantom));
                trophy.m_7695_(matrixStackIn, phantomVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85841_(1.1f, 1.1f, 1.1f);
                matrixStackIn.m_85837_(0.0, (double)0.05f, 0.0);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                VertexConsumer phantomArmorVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocKnightPhantomArmor));
                trophy.renderHelmToBuffer(matrixStackIn, phantomArmorVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case ALPHA_YETI: {
                matrixStackIn.m_85841_(0.2f, 0.2f, 0.2f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                matrixStackIn.m_85837_(0.0, -1.5, 0.0);
                VertexConsumer yetiVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocYeti));
                trophy.m_7695_(matrixStackIn, yetiVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case QUEST_RAM: {
                matrixStackIn.m_85841_(0.7f, 0.7f, 0.7f);
                trophy.setRotations(animationProgress * 4.5f, y, 0.0f);
                VertexConsumer ramVertex = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)textureLocQuestRam));
                trophy.m_7695_(matrixStackIn, ramVertex, combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
        matrixStackIn.m_85849_();
    }
}

