/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.jei.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.compat.jei.FakeItemEntity;

public class FakeItemEntityRenderer
implements IIngredientRenderer<FakeItemEntity> {
    private final float bobOffs = RandomSource.m_216327_().m_188501_() * (float)Math.PI * 2.0f;
    private final int size;

    public FakeItemEntityRenderer(int size) {
        this.size = size;
    }

    public int getWidth() {
        return this.size;
    }

    public int getHeight() {
        return this.size;
    }

    public void render(PoseStack stack, @Nullable FakeItemEntity item) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (item != null && level != null) {
            try {
                PoseStack modelView = RenderSystem.m_157191_();
                modelView.m_85836_();
                modelView.m_166854_(stack.m_85850_().m_85861_());
                this.renderItemEntity(item.stack(), (Level)level);
                modelView.m_85849_();
                RenderSystem.m_157182_();
            }
            catch (Exception e) {
                TwilightForestMod.LOGGER.error("Error drawing item in JEI!", (Throwable)e);
            }
        }
    }

    public List<Component> getTooltip(FakeItemEntity item, TooltipFlag flag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add(item.stack().m_41720_().m_41466_());
        if (flag.m_7050_()) {
            tooltip.add((Component)Component.m_237113_((String)Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.stack().m_41720_())).toString()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        return tooltip;
    }

    private void renderItemEntity(ItemStack stack, Level level) {
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_(16.0, 32.0, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack posestack1 = new PoseStack();
        posestack1.m_85837_(0.0, 0.0, 1000.0);
        posestack1.m_85841_(50.0f, 50.0f, 50.0f);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(20.0f);
        quaternion.m_80148_(quaternion1);
        posestack1.m_85845_(quaternion);
        posestack1.m_85845_(Vector3f.f_122222_.m_122240_(35.0f));
        posestack1.m_85845_(Vector3f.f_122224_.m_122240_(145.0f));
        Lighting.m_166384_();
        quaternion1.m_80157_();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(level);
        Objects.requireNonNull(item).m_32045_(stack);
        RenderSystem.m_69890_(() -> this.render(item, Minecraft.m_91087_().m_91297_(), posestack1, (MultiBufferSource)buffer, 0xF000F0));
        buffer.m_109911_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public void render(ItemEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.m_85836_();
        ItemStack itemstack = entity.m_32055_();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(itemstack, entity.m_9236_(), null, entity.m_19879_());
        float f1 = Mth.m_14031_((float)(((float)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_() + partialTicks) / 10.0f + this.bobOffs)) * 0.1f + 0.1f;
        float f2 = bakedmodel.m_7442_().m_111808_((ItemTransforms.TransformType)ItemTransforms.TransformType.GROUND).f_111757_.m_122260_();
        stack.m_85837_(0.0, (double)(f1 + 0.25f * f2), 0.0);
        float f3 = this.getSpin(partialTicks);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(f3));
        stack.m_85836_();
        Minecraft.m_91087_().m_91291_().m_115143_(itemstack, ItemTransforms.TransformType.GROUND, false, stack, buffer, light, OverlayTexture.f_118083_, bakedmodel);
        stack.m_85849_();
        stack.m_85849_();
    }

    public float getSpin(float pPartialTicks) {
        return ((float)Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_46467_() + pPartialTicks) / 20.0f + this.bobOffs;
    }
}

