/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.data.custom;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFRecipes;

public abstract class TransformationPowderProvider
implements DataProvider {
    private final DataGenerator generator;
    private final String modId;
    private final ExistingFileHelper helper;
    protected final Map<String, Triple<EntityType<?>, EntityType<?>, Boolean>> builders = Maps.newLinkedHashMap();

    public TransformationPowderProvider(DataGenerator generator, String modId, ExistingFileHelper helper) {
        this.generator = generator;
        this.modId = modId;
        this.helper = helper;
    }

    public abstract void registerTransforms();

    public void m_213708_(CachedOutput cache) {
        this.builders.clear();
        this.registerTransforms();
        this.builders.forEach((name, transform) -> {
            List list = this.builders.keySet().stream().filter(s -> ForgeRegistries.ENTITY_TYPES.containsValue((Object)((EntityType)transform.getLeft()))).filter(s -> ForgeRegistries.ENTITY_TYPES.containsValue((Object)((EntityType)transform.getMiddle()))).filter(s -> !this.builders.containsKey(s)).filter(this::missing).collect(Collectors.toList());
            if (!list.isEmpty()) {
                throw new IllegalArgumentException(String.format("Duplicate Transformation Powder Transformations: %s", list.stream().map(Objects::toString).collect(Collectors.joining(", "))));
            }
            JsonObject obj = this.serializeToJson((EntityType)transform.getLeft(), (EntityType)transform.getMiddle(), (Boolean)transform.getRight());
            Path path = this.createPath(new ResourceLocation(this.modId, name));
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)obj, (Path)path);
            }
            catch (IOException e) {
                TwilightForestMod.LOGGER.error("Couldn't save Transformation Powder recipe to {}", (Object)path, (Object)e);
            }
        });
    }

    private boolean missing(String name) {
        return this.helper == null || !this.helper.exists(new ResourceLocation(this.modId, name), (ExistingFileHelper.IResourceType)new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", "crumble_horn/"));
    }

    private Path createPath(ResourceLocation name) {
        return this.generator.m_123916_().resolve("data/" + name.m_135827_() + "/recipes/transformation_powder/" + name.m_135815_() + ".json");
    }

    private JsonObject serializeToJson(EntityType<?> transformFrom, EntityType<?> transformTo, boolean reversible) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", ForgeRegistries.RECIPE_SERIALIZERS.getKey((Object)((RecipeSerializer)TFRecipes.TRANSFORMATION_SERIALIZER.get())).toString());
        jsonobject.addProperty("from", ForgeRegistries.ENTITY_TYPES.getKey(transformFrom).toString());
        jsonobject.addProperty("to", ForgeRegistries.ENTITY_TYPES.getKey(transformTo).toString());
        jsonobject.addProperty("reversible", Boolean.valueOf(reversible));
        return jsonobject;
    }

    public String m_6055_() {
        return this.modId + " Transformation Powder Transformations";
    }

    public void addOneWayTransform(EntityType<?> from, EntityType<?> to) {
        this.builders.put(ForgeRegistries.ENTITY_TYPES.getKey(from).m_135815_() + "_to_" + ForgeRegistries.ENTITY_TYPES.getKey(to).m_135815_(), Triple.of(from, to, (Object)false));
    }

    public void addTwoWayTransform(EntityType<?> from, EntityType<?> to) {
        this.builders.put(ForgeRegistries.ENTITY_TYPES.getKey(from).m_135815_() + "_to_" + ForgeRegistries.ENTITY_TYPES.getKey(to).m_135815_(), Triple.of(from, to, (Object)true));
    }
}

