/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.entity.boss.Naga;
import twilightforest.init.TFSounds;
import twilightforest.util.EntityUtil;

public class NagaMovementPattern
extends Goal {
    private final Naga naga;
    private MovementState state;
    private int stateCounter;
    private boolean clockwise;

    public NagaMovementPattern(Naga naga) {
        this.naga = naga;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.m_8041_();
    }

    public boolean m_8036_() {
        return this.naga.m_5448_() != null && this.naga.areSelfAndTargetInHome((Entity)this.naga.m_5448_());
    }

    public void m_8041_() {
        this.state = MovementState.CIRCLE;
        this.stateCounter = 15;
        this.clockwise = false;
    }

    public void m_8037_() {
        if (!this.naga.m_21573_().m_26571_()) {
            if (this.naga.m_21573_().m_26577_()) {
                this.naga.m_21573_().m_26573_();
            }
            return;
        }
        switch (this.state) {
            case INTIMIDATE: {
                this.naga.m_21573_().m_26573_();
                this.naga.m_21563_().m_24960_((Entity)this.naga.m_5448_(), 30.0f, 30.0f);
                this.naga.m_21391_((Entity)this.naga.m_5448_(), 30.0f, 30.0f);
                this.naga.f_20902_ = 0.1f;
                break;
            }
            case CRUMBLE: {
                this.naga.m_21573_().m_26573_();
                this.crumbleBelowTarget(2);
                this.crumbleBelowTarget(3);
                break;
            }
            case CHARGE: {
                BlockPos tpoint = this.findCirclePoint(this.clockwise, 14.0, Math.PI);
                this.naga.m_21573_().m_26519_((double)tpoint.m_123341_(), (double)tpoint.m_123342_(), (double)tpoint.m_123343_(), 1.0);
                this.naga.setCharging(true);
                break;
            }
            case CIRCLE: {
                double radius = this.stateCounter % 2 == 0 ? 12.0 : 14.0;
                double rotation = 1.0;
                if (this.stateCounter == 2) {
                    radius = 16.0;
                }
                if (this.stateCounter == 1) {
                    rotation = 0.1;
                }
                BlockPos tpoint = this.findCirclePoint(this.clockwise, radius, rotation);
                this.naga.m_21573_().m_26519_((double)tpoint.m_123341_(), (double)tpoint.m_123342_(), (double)tpoint.m_123343_(), 1.0);
                break;
            }
            case DAZE: {
                this.naga.m_21573_().m_26573_();
                this.naga.setDazed(true);
                this.naga.setCharging(false);
            }
        }
        --this.stateCounter;
        if (this.stateCounter <= 0) {
            this.transitionState();
        }
    }

    private void transitionState() {
        this.naga.setDazed(false);
        this.naga.setCharging(false);
        switch (this.state) {
            case INTIMIDATE: {
                boolean bl = this.clockwise = !this.clockwise;
                if (this.naga.m_5448_().m_20191_().f_82289_ > this.naga.m_20191_().f_82292_) {
                    this.doCrumblePlayer();
                    break;
                }
                this.doCharge();
                break;
            }
            case CRUMBLE: {
                this.doCharge();
                break;
            }
            case CHARGE: 
            case DAZE: {
                this.doCircle();
                break;
            }
            case CIRCLE: {
                this.doIntimidate();
            }
        }
    }

    public void doDaze() {
        this.state = MovementState.DAZE;
        this.naga.m_21573_().m_26573_();
        this.stateCounter = 60 + this.naga.m_217043_().m_188503_(40);
    }

    public void doCircle() {
        this.state = MovementState.CIRCLE;
        this.stateCounter += 10 + this.naga.m_217043_().m_188503_(10);
        this.naga.goNormal();
    }

    public void doCrumblePlayer() {
        this.state = MovementState.CRUMBLE;
        this.stateCounter = 20 + this.naga.m_217043_().m_188503_(20);
        this.naga.goSlow();
    }

    private void doCharge() {
        this.state = MovementState.CHARGE;
        this.stateCounter = 3;
        this.naga.goFast();
    }

    private void doIntimidate() {
        this.state = MovementState.INTIMIDATE;
        this.naga.m_5496_((SoundEvent)TFSounds.NAGA_RATTLE.get(), 4.0f, this.naga.m_6100_());
        this.naga.m_146850_(GameEvent.f_223709_);
        this.stateCounter += 15 + this.naga.m_217043_().m_188503_(10);
        this.naga.goSlow();
    }

    private void crumbleBelowTarget(int range) {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.naga.m_9236_(), (Entity)this.naga)) {
            return;
        }
        int targetY = (int)this.naga.m_5448_().m_20191_().f_82289_;
        int floor = (int)this.naga.m_20191_().f_82289_;
        if (targetY > floor) {
            int dx = (int)this.naga.m_5448_().m_20185_() + this.naga.m_217043_().m_188503_(range) - this.naga.m_217043_().m_188503_(range);
            int dz = (int)this.naga.m_5448_().m_20189_() + this.naga.m_217043_().m_188503_(range) - this.naga.m_217043_().m_188503_(range);
            int dy = targetY - this.naga.m_217043_().m_188503_(range) + this.naga.m_217043_().m_188503_(range > 1 ? range - 1 : range);
            if (dy <= floor) {
                dy = targetY;
            }
            BlockPos pos = new BlockPos(dx, dy, dz);
            if (EntityUtil.canDestroyBlock(this.naga.m_9236_(), pos, (Entity)this.naga)) {
                this.naga.m_9236_().m_46961_(pos, true);
                for (int k = 0; k < 20; ++k) {
                    double d = this.naga.m_217043_().m_188583_() * 0.02;
                    double d1 = this.naga.m_217043_().m_188583_() * 0.02;
                    double d2 = this.naga.m_217043_().m_188583_() * 0.02;
                    this.naga.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.naga.m_20185_() + (double)(this.naga.m_217043_().m_188501_() * this.naga.m_20205_() * 2.0f) - (double)this.naga.m_20205_(), this.naga.m_20186_() + (double)(this.naga.m_217043_().m_188501_() * this.naga.m_20206_()), this.naga.m_20189_() + (double)(this.naga.m_217043_().m_188501_() * this.naga.m_20205_() * 2.0f) - (double)this.naga.m_20205_(), d, d1, d2);
                }
            }
        }
    }

    private BlockPos findCirclePoint(boolean clockwise, double radius, double rotation) {
        LivingEntity toCircle = this.naga.m_5448_();
        double vecx = this.naga.m_20185_() - toCircle.m_20185_();
        double vecz = this.naga.m_20189_() - toCircle.m_20189_();
        float rangle = (float)Math.atan2(vecz, vecx);
        rangle = (float)((double)rangle + (clockwise ? rotation : -rotation));
        double dx = (double)Mth.m_14089_((float)rangle) * radius;
        double dz = (double)Mth.m_14031_((float)rangle) * radius;
        double dy = Math.min(this.naga.m_20191_().f_82289_, toCircle.m_20186_());
        return new BlockPos(toCircle.m_20185_() + dx, dy, toCircle.m_20189_() + dz);
    }

    public MovementState getState() {
        return this.state;
    }

    public static enum MovementState {
        INTIMIDATE,
        CRUMBLE,
        CHARGE,
        CIRCLE,
        DAZE;

    }
}

