/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFDamageSources;
import twilightforest.init.TFItems;

public class GiantMiner
extends Monster {
    public GiantMiner(EntityType<? extends GiantMiner> type, Level world) {
        super(type, world);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            this.m_21409_(slot, 0.0f);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected double m_6639_(LivingEntity attackTarget) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20206_();
            }

            protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
                double eyeHeightDistToEnemySqr = this.f_25540_.m_20275_(pEnemy.m_20185_(), pEnemy.m_20186_() - (double)this.f_25540_.m_20192_() + (double)pEnemy.m_20192_(), pEnemy.m_20189_());
                super.m_6739_(pEnemy, Math.min(pDistToEnemySqr, eyeHeightDistToEnemySqr * 0.8));
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(accessor, difficulty, reason, spawnDataIn, dataTag);
        this.m_213945_(accessor.m_213780_(), difficulty);
        this.m_213946_(accessor.m_213780_(), difficulty);
        return data;
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.GIANT_PICKAXE.get()));
    }

    protected void m_214095_(RandomSource random, float chance) {
    }

    protected void m_217051_(RandomSource random, float chance, EquipmentSlot slot) {
    }

    public boolean m_7327_(Entity entity) {
        entity.m_6469_(TFDamageSources.ant((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
        return super.m_7327_(entity);
    }

    public double m_6049_() {
        return -2.5;
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_5545_(LevelAccessor accessor, MobSpawnType reason) {
        List giantsNearby = accessor.m_45976_(GiantMiner.class, this.m_20191_().m_82377_(100.0, 10.0, 100.0));
        return giantsNearby.size() < 5;
    }

    public static boolean canSpawn(EntityType<? extends GiantMiner> type, ServerLevelAccessor accessor, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return accessor.m_8055_(pos.m_7495_()).m_204336_(BlockTagGenerator.GIANTS_SPAWNABLE_ON);
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }
}

