/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class MazeSlime
extends Slime {
    private static final AttributeModifier DOUBLE_HEALTH = new AttributeModifier("Maze slime double health", 1.0, AttributeModifier.Operation.MULTIPLY_BASE);

    public MazeSlime(EntityType<? extends MazeSlime> type, Level world) {
        super(type, world);
    }

    public void m_7839_(int size, boolean resetHealth) {
        super.m_7839_(size, resetHealth);
        this.f_21364_ += 3;
    }

    public static boolean getCanSpawnHere(EntityType<MazeSlime> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46791_() != Difficulty.PEACEFUL && MazeSlime.m_217057_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22266_(Attributes.f_22276_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        assert (health != null);
        health.m_22125_(DOUBLE_HEALTH);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public double m_6049_() {
        return 0.25;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_33633_() ? (SoundEvent)TFSounds.MAZE_SLIME_HURT_SMALL.get() : (SoundEvent)TFSounds.MAZE_SLIME_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_33633_() ? (SoundEvent)TFSounds.MAZE_SLIME_DEATH_SMALL.get() : (SoundEvent)TFSounds.MAZE_SLIME_DEATH.get();
    }

    protected SoundEvent m_7905_() {
        return this.m_33633_() ? (SoundEvent)TFSounds.MAZE_SLIME_SQUISH_SMALL.get() : (SoundEvent)TFSounds.MAZE_SLIME_SQUISH.get();
    }

    protected SoundEvent m_7903_() {
        return this.m_33633_() ? (SoundEvent)TFSounds.MAZE_SLIME_SQUISH_SMALL.get() : (SoundEvent)TFSounds.MAZE_SLIME_SQUISH.get();
    }

    protected boolean m_7483_() {
        return true;
    }

    protected boolean spawnCustomParticles() {
        int i = this.m_33632_();
        for (int j = 0; j < i * 8; ++j) {
            float f = this.m_217043_().m_188501_() * ((float)Math.PI * 2);
            float f1 = this.m_217043_().m_188501_() * 0.5f + 0.5f;
            float f2 = Mth.m_14031_((float)f) * (float)i * 0.5f * f1;
            float f3 = Mth.m_14089_((float)f) * (float)i * 0.5f * f1;
            Level world = this.m_9236_();
            double d0 = this.m_20185_() + (double)f2;
            double d1 = this.m_20189_() + (double)f3;
            BlockState state = ((Block)TFBlocks.MAZESTONE_BRICK.get()).m_49966_();
            world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), d0, this.m_20191_().f_82289_, d1, 0.0, 0.0, 0.0);
        }
        return true;
    }

    protected float m_6121_() {
        return 0.1f * (float)this.m_33632_();
    }
}

