/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.init.TFItems;
import twilightforest.item.MazebreakerPickItem;
import twilightforest.item.MinotaurAxeItem;

@Mod.EventBusSubscriber(modid="twilightforest")
public class ToolEvents {
    private static final int KNIGHTMETAL_BONUS_DAMAGE = 2;
    private static final int MINOTAUR_AXE_BONUS_DAMAGE = 7;

    @SubscribeEvent
    public static void onEnderBowHit(ProjectileImpactEvent evt) {
        Projectile arrow = evt.getProjectile();
        Entity entity = arrow.m_37282_();
        if (entity instanceof Player) {
            EntityHitResult result;
            Player player = (Player)entity;
            entity = evt.getRayTraceResult();
            if (entity instanceof EntityHitResult && (entity = (result = (EntityHitResult)entity).m_82443_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (arrow.m_37282_() != result.m_82443_() && arrow.getPersistentData().m_128441_("twilightforest:ender")) {
                    double sourceX = player.m_20185_();
                    double sourceY = player.m_20186_();
                    double sourceZ = player.m_20189_();
                    float sourceYaw = player.m_146908_();
                    float sourcePitch = player.m_146909_();
                    @Nullable Entity playerVehicle = player.m_20202_();
                    player.m_146922_(living.m_146908_());
                    player.m_6021_(living.m_20185_(), living.m_20186_(), living.m_20189_());
                    player.f_19802_ = 40;
                    player.m_9236_().m_7605_((Entity)player, (byte)46);
                    if (living.m_20159_() && living.m_20202_() != null) {
                        player.m_7998_(living.m_20202_(), true);
                        living.m_8127_();
                    }
                    player.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                    living.m_146922_(sourceYaw);
                    living.m_146926_(sourcePitch);
                    living.m_6021_(sourceX, sourceY, sourceZ);
                    living.m_9236_().m_7605_((Entity)player, (byte)46);
                    if (playerVehicle != null) {
                        living.m_7998_(playerVehicle, true);
                        player.m_8127_();
                    }
                    living.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void fieryToolSetFire(LivingAttackEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && ((living = (LivingEntity)entity).m_21205_().m_150930_((Item)TFItems.FIERY_SWORD.get()) || living.m_21205_().m_150930_((Item)TFItems.FIERY_PICKAXE.get())) && !event.getEntity().m_5825_()) {
            event.getEntity().m_20254_(1);
        }
    }

    @SubscribeEvent
    public static void onKnightmetalToolDamage(LivingHurtEvent event) {
        LivingEntity living;
        ItemStack weapon;
        Entity entity;
        LivingEntity target = event.getEntity();
        if (!target.m_9236_().m_5776_() && (entity = event.getSource().m_7640_()) instanceof LivingEntity && !(weapon = (living = (LivingEntity)entity).m_21205_()).m_41619_()) {
            if (target.m_21230_() > 0 && (weapon.m_150930_((Item)TFItems.KNIGHTMETAL_PICKAXE.get()) || weapon.m_150930_((Item)TFItems.KNIGHTMETAL_SWORD.get()))) {
                if (target.m_21207_() > 0.0f) {
                    int moreBonus = (int)(2.0f * target.m_21207_());
                    event.setAmount(event.getAmount() + (float)moreBonus);
                } else {
                    event.setAmount(event.getAmount() + 2.0f);
                }
                ((ServerLevel)target.m_9236_()).m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
            } else if (target.m_21230_() == 0 && weapon.m_150930_((Item)TFItems.KNIGHTMETAL_AXE.get())) {
                event.setAmount(event.getAmount() + 2.0f);
                ((ServerLevel)target.m_9236_()).m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
            }
        }
    }

    @SubscribeEvent
    public static void onMinotaurAxeCharge(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7640_();
        if (!target.m_9236_().m_5776_() && source instanceof LivingEntity) {
            ItemStack weapon;
            LivingEntity living = (LivingEntity)source;
            if (source.m_20142_() && (event.getSource().m_19385_().equals("player") || event.getSource().m_19385_().equals("mob")) && !(weapon = living.m_21205_()).m_41619_() && weapon.m_41720_() instanceof MinotaurAxeItem) {
                event.setAmount(event.getAmount() + 7.0f);
                ((ServerLevel)target.m_9236_()).m_7726_().m_8394_((Entity)target, (Packet)new ClientboundAnimatePacket((Entity)target, 5));
            }
        }
    }

    @SubscribeEvent
    public static void damageToolsExtra(BlockEvent.BreakEvent event) {
        ItemStack stack = event.getPlayer().m_21205_();
        if ((event.getState().m_204336_(BlockTagGenerator.MAZESTONE) || event.getState().m_204336_(BlockTagGenerator.CASTLE_BLOCKS)) && stack.m_41763_() && !(stack.m_41720_() instanceof MazebreakerPickItem)) {
            stack.m_41622_(16, (LivingEntity)event.getPlayer(), user -> user.m_21190_(InteractionHand.MAIN_HAND));
        }
    }
}

