/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import twilightforest.init.TFRecipes;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStats;
import twilightforest.util.WorldUtil;

public class CrumbleHornItem
extends Item {
    private static final int CHANCE_HARVEST = 20;
    private static final int CHANCE_CRUMBLE = 5;

    public CrumbleHornItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        player.m_5496_((SoundEvent)TFSounds.QUEST_RAM_AMBIENT.get(), 1.0f, 0.8f);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity living, int count) {
        if (count > 10 && count % 5 == 0 && !living.m_9236_().m_5776_()) {
            int crumbled = this.doCrumble(living.m_9236_(), living);
            if (crumbled > 0) {
                stack.m_41622_(crumbled, living, user -> user.m_21190_(living.m_7655_()));
            }
            living.m_9236_().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), (SoundEvent)TFSounds.QUEST_RAM_AMBIENT.get(), living.m_5720_(), 1.0f, 0.8f);
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() == newStack.m_41720_();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || newStack.m_41720_() != oldStack.m_41720_();
    }

    private int doCrumble(Level world, LivingEntity living) {
        double range = 3.0;
        double radius = 2.0;
        Vec3 srcVec = new Vec3(living.m_20185_(), living.m_20186_() + (double)living.m_20192_(), living.m_20189_());
        Vec3 lookVec = living.m_20154_().m_82490_(3.0);
        Vec3 destVec = srcVec.m_82549_(lookVec);
        AABB crumbleBox = new AABB(destVec.m_7096_() - 2.0, destVec.m_7098_() - 2.0, destVec.m_7094_() - 2.0, destVec.m_7096_() + 2.0, destVec.m_7098_() + 2.0, destVec.m_7094_() + 2.0);
        return this.crumbleBlocksInAABB(world, living, crumbleBox);
    }

    private int crumbleBlocksInAABB(Level world, LivingEntity living, AABB box) {
        int crumbled = 0;
        for (BlockPos pos : WorldUtil.getAllInBB(box)) {
            Player player;
            if (!this.crumbleBlock(world, living, pos)) continue;
            ++crumbled;
            if (!(living instanceof Player) || !((player = (Player)living) instanceof ServerPlayer)) continue;
            player.m_36220_((ResourceLocation)TFStats.BLOCKS_CRUMBLED.get());
        }
        return crumbled;
    }

    private boolean crumbleBlock(Level world, LivingEntity living, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        AtomicBoolean flag = new AtomicBoolean(false);
        if (state.m_60795_()) {
            return false;
        }
        if (living instanceof Player && MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, state, (Player)living))) {
            return false;
        }
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.m_7465_().m_44013_((RecipeType)TFRecipes.CRUMBLE_RECIPE.get()).forEach(recipe -> {
                if (flag.get()) {
                    return;
                }
                if (recipe.result().m_60713_(Blocks.f_50016_)) {
                    if (recipe.input().m_60713_(block) && world.m_213780_().m_188503_(20) == 0 && !flag.get()) {
                        if (living instanceof Player) {
                            if (block.canHarvestBlock(state, (BlockGetter)world, pos, (Player)living)) {
                                world.m_7471_(pos, false);
                                block.m_6240_(world, (Player)living, pos, state, world.m_7702_(pos), ItemStack.f_41583_);
                                world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                                this.postTrigger(living);
                                flag.set(true);
                            }
                        } else if (ForgeEventFactory.getMobGriefingEvent((Level)world, (Entity)living)) {
                            world.m_46961_(pos, true);
                            this.postTrigger(living);
                            flag.set(true);
                        }
                    }
                } else if (recipe.input().m_60713_(block) && world.m_213780_().m_188503_(5) == 0 && !flag.get()) {
                    world.m_7731_(pos, recipe.result().m_60734_().m_152465_(state), 3);
                    world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
                    this.postTrigger(living);
                    flag.set(true);
                }
            });
        }
        return flag.get();
    }

    private void postTrigger(LivingEntity living) {
        if (living instanceof ServerPlayer) {
            Player player = (Player)living;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }
}

