/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.armor.YetiArmorModel;
import twilightforest.init.TFEnchantments;
import twilightforest.init.TFItems;

public class YetiArmorItem
extends ArmorItem {
    private static final MutableComponent TOOLTIP = Component.m_237115_((String)"item.twilightforest.yeti_armor.tooltip").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));

    public YetiArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        AtomicBoolean badEnchant = new AtomicBoolean();
        EnchantmentHelper.m_44831_((ItemStack)book).forEach((enchantment, integer) -> {
            if (Objects.equals(Enchantments.f_44972_, enchantment) || Objects.equals(TFEnchantments.FIRE_REACT.get(), enchantment)) {
                badEnchant.set(true);
            }
        });
        return !badEnchant.get();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return !((Enchantment)TFEnchantments.FIRE_REACT.get()).equals(enchantment) && !Enchantments.f_44972_.equals(enchantment) && !((Enchantment)TFEnchantments.CHILL_AURA.get()).equals(enchantment) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.CHEST) {
            return "twilightforest:textures/armor/yetiarmor_2.png";
        }
        return "twilightforest:textures/armor/yetiarmor_1.png";
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab)) {
            ItemStack stack = new ItemStack((ItemLike)this);
            switch (this.m_40402_()) {
                case HEAD: 
                case CHEST: 
                case LEGS: {
                    stack.m_41663_(Enchantments.f_44965_, 2);
                    break;
                }
                case FEET: {
                    stack.m_41663_(Enchantments.f_44965_, 2);
                    stack.m_41663_(Enchantments.f_44967_, 4);
                    break;
                }
            }
            items.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)TOOLTIP);
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.m_150930_((Item)TFItems.YETI_BOOTS.get());
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ArmorRender.INSTANCE);
    }

    private static final class ArmorRender
    implements IClientItemExtensions {
        private static final ArmorRender INSTANCE = new ArmorRender();

        private ArmorRender() {
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> model) {
            EntityModelSet models = Minecraft.m_91087_().m_167973_();
            ModelPart root = models.m_171103_(slot == EquipmentSlot.LEGS ? TFModelLayers.YETI_ARMOR_INNER : TFModelLayers.YETI_ARMOR_OUTER);
            return new YetiArmorModel(slot, root);
        }
    }
}

