/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import twilightforest.init.TFBlocks;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.feature.config.ThornsConfig;

public class ThornFeature
extends Feature<ThornsConfig> {
    public ThornFeature(Codec<ThornsConfig> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<ThornsConfig> ctx) {
        WorldGenLevel world = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        RandomSource rand = ctx.m_225041_();
        int nextLength = 2 + rand.m_188503_(4);
        int maxLength = 2 + rand.m_188503_(4) + rand.m_188503_(4) + rand.m_188503_(4);
        this.placeThorns(world, rand, pos, nextLength, Direction.UP, maxLength, pos, (ThornsConfig)ctx.m_159778_(), true);
        return true;
    }

    private void placeThorns(WorldGenLevel world, RandomSource rand, BlockPos pos, int length, Direction dir, int maxLength, BlockPos oPos, ThornsConfig config, boolean avoidGiantCloud) {
        Direction nextDir;
        int middle;
        boolean complete = false;
        for (int i = 0; i < length; ++i) {
            BlockPos dPos = pos.m_5484_(dir, i);
            if (avoidGiantCloud && dPos.m_123342_() - 64 > WorldUtil.getBaseHeight((LevelAccessor)world, dPos.m_123341_(), dPos.m_123343_(), Heightmap.Types.MOTION_BLOCKING_NO_LEAVES) || Math.abs(dPos.m_123341_() - oPos.m_123341_()) >= config.maxSpread() || Math.abs(dPos.m_123343_() - oPos.m_123343_()) >= config.maxSpread() || !this.canPlaceThorns((LevelAccessor)world, dPos)) break;
            world.m_7731_(dPos, (BlockState)((Block)TFBlocks.BROWN_THORNS.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()), 3);
            world.m_46865_(dPos).m_8113_(dPos);
            if (i != length - 1) continue;
            complete = true;
            if (rand.m_188503_(config.chanceOfLeaf()) != 0 || !world.m_46859_(dPos.m_121945_(dir))) continue;
            if (rand.m_188503_(config.chanceLeafIsRose()) > 0) {
                world.m_7731_(dPos.m_121945_(dir), (BlockState)((Block)TFBlocks.THORN_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 3);
                continue;
            }
            world.m_7731_(dPos.m_121945_(dir), ((Block)TFBlocks.THORN_ROSE.get()).m_49966_(), 3);
        }
        if (complete && maxLength > 1) {
            Direction nextDir2 = Direction.m_235672_((RandomSource)rand);
            BlockPos nextPos = pos.m_5484_(dir, length - 1).m_121945_(nextDir2);
            int nextLength = 1 + rand.m_188503_(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir2, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.m_188503_(config.chanceOfBranch()) == 0) {
            middle = rand.m_188503_(length);
            nextDir = Direction.m_235672_((RandomSource)rand);
            BlockPos nextPos = pos.m_5484_(dir, middle).m_121945_(nextDir);
            int nextLength = 1 + rand.m_188503_(maxLength);
            this.placeThorns(world, rand, nextPos, nextLength, nextDir, maxLength - 1, oPos, config, false);
        }
        if (complete && length > 3 && rand.m_188503_(config.chanceOfLeaf()) == 0) {
            middle = rand.m_188503_(length);
            nextDir = Direction.m_235672_((RandomSource)rand);
            BlockPos nextPos = pos.m_5484_(dir, middle).m_121945_(nextDir);
            if (world.m_46859_(nextPos)) {
                world.m_7731_(nextPos, (BlockState)((Block)TFBlocks.THORN_LEAVES.get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1)), 3);
            }
        }
    }

    private boolean canPlaceThorns(LevelAccessor world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_60795_() || state.m_204336_(BlockTags.f_13035_);
    }
}

