/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.init.TFFeatureModifiers;

public class DangleFromTreeDecorator
extends TreeDecorator {
    public static final Codec<DangleFromTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("attempts_minimum").forGetter(o -> o.count), (App)Codec.intRange((int)0, (int)32).fieldOf("random_add_attempts").orElse((Object)0).forGetter(o -> o.randomAddCount), (App)Codec.intRange((int)1, (int)24).fieldOf("minimum_required_length").forGetter(o -> o.minimumRequiredLength), (App)Codec.intRange((int)1, (int)24).fieldOf("base_length").forGetter(o -> o.baseLength), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_length").orElse((Object)0).forGetter(o -> o.randomAddLength), (App)WeightedStateProvider.f_68808_.fieldOf("rope_provider").forGetter(o -> o.rope), (App)WeightedStateProvider.f_68808_.fieldOf("baggage_provider").forGetter(o -> o.baggage)).apply((Applicative)instance, DangleFromTreeDecorator::new));
    private final int count;
    private final int randomAddCount;
    private final int minimumRequiredLength;
    private final int baseLength;
    private final int randomAddLength;
    private final WeightedStateProvider rope;
    private final WeightedStateProvider baggage;

    public DangleFromTreeDecorator(int count, int randomAddCount, int minimumRequiredLength, int baseLength, int randomAddLength, WeightedStateProvider rope, WeightedStateProvider baggage) {
        this.count = count;
        this.randomAddCount = randomAddCount;
        this.minimumRequiredLength = minimumRequiredLength;
        this.baseLength = baseLength;
        this.randomAddLength = randomAddLength;
        this.rope = rope;
        this.baggage = baggage;
    }

    protected TreeDecoratorType<DangleFromTreeDecorator> m_6663_() {
        return (TreeDecoratorType)TFFeatureModifiers.DANGLING_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        if (context.m_226069_().isEmpty()) {
            return;
        }
        int totalTries = this.count + context.m_226067_().m_188503_(this.randomAddCount + 1);
        int leafTotal = context.m_226069_().size();
        totalTries = Math.min(totalTries, leafTotal);
        for (int attempt = 0; attempt < totalTries; ++attempt) {
            boolean clearedOfPossibleLeaves = false;
            BlockPos pos = (BlockPos)context.m_226069_().get(context.m_226067_().m_188503_(leafTotal));
            if (pos.m_123341_() == ((BlockPos)context.m_226068_().get(0)).m_123342_() && pos.m_123343_() == ((BlockPos)context.m_226068_().get(0)).m_123343_()) {
                return;
            }
            int cordLength = this.baseLength + context.m_226067_().m_188503_(this.randomAddLength + 1);
            for (int ropeUnrolling = 1; ropeUnrolling <= cordLength; ++ropeUnrolling) {
                boolean isAir = context.m_226058_().m_7433_(pos.m_6625_(ropeUnrolling), BlockBehaviour.BlockStateBase::m_60795_);
                if (!clearedOfPossibleLeaves && isAir) {
                    clearedOfPossibleLeaves = true;
                }
                if (!clearedOfPossibleLeaves || isAir) continue;
                cordLength = ropeUnrolling;
                break;
            }
            if (cordLength <= this.minimumRequiredLength) continue;
            BlockState rope = this.rope.m_213972_(context.m_226067_(), pos);
            for (int ropeUnrolling = 1; ropeUnrolling < cordLength; ++ropeUnrolling) {
                pos = pos.m_6625_(1);
                if (!context.m_226058_().m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_)) continue;
                context.m_226061_(pos, rope);
            }
            if (!context.m_226059_(pos = pos.m_6625_(1))) continue;
            context.m_226061_(pos, this.baggage.m_213972_(context.m_226067_(), pos));
        }
    }
}

