/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import ovh.corail.tombstone.combine.CombineRecipe;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class CombineRecipeCategory
implements IRecipeCategory<CombineRecipe> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/toasts.png");
    private final RecipeType<CombineRecipe> recipeType;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable mouseOn;
    private final IDrawable mouseOff;

    CombineRecipeCategory(RecipeType<CombineRecipe> recipeType, IGuiHelper guiHelper) {
        this.recipeType = recipeType;
        this.background = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 0, 168, 124, 18).addPadding(0, 0, 20, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)ItemAdvancement.IconType.COMBINATION.getItemStack());
        this.mouseOn = guiHelper.drawableBuilder(TEXTURE, 234, 20, 20, 20).build();
        this.mouseOff = guiHelper.drawableBuilder(TEXTURE, 196, 0, 20, 20).build();
    }

    public RecipeType<CombineRecipe> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayoutBuilder, CombineRecipe recipe, IFocusGroup focuses) {
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 20, 0).addIngredients(recipe.combineOn());
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 69, 0).addIngredients(recipe.combined());
        recipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 127, 0).addItemStack(recipe.result().get());
    }

    public void draw(CombineRecipe recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        if (TimeHelper.inIntervalBefore(TimeHelper.systemTime(), 2000, 700)) {
            this.mouseOn.draw(poseStack, -3, -3);
        } else {
            this.mouseOff.draw(poseStack, -1, -3);
        }
    }
}

