/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.CMessageEffect;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public final class EnchantmentCurseOfBones
extends ArmorEnchantment {
    private static final String BONE_SHIELD_LAST_PROC_NBT_LONG = "bone_shield_last_proc";

    public EnchantmentCurseOfBones() {
        super("curse_of_bones", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_CHEST, EquipmentSlot.CHEST);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentCurseOfBones.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.curseOfBonesEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        amplifier = EntityHelper.getCurseOfBonesLevel(wearer);
        if (amplifier > 0) {
            boolean valid;
            double scale = (double)amplifier / (double)this.m_6586_();
            int delay = TimeHelper.tickFromSecond(60 - (int)(scale * 40.0));
            CompoundTag persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.m_128425_(BONE_SHIELD_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.m_128454_(BONE_SHIELD_LAST_PROC_NBT_LONG) - (long)wearer.f_19797_;
                if (timeLeft <= 0L) {
                    persistantData.m_128473_(BONE_SHIELD_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.m_128356_(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
                }
            }
            if (valid && wearer.m_217043_().m_188503_(Math.max(10, this.m_6586_())) < amplifier) {
                MobEffectInstance effect = new MobEffectInstance(ModEffects.bone_shield, TimeHelper.tickFromSecond(10), amplifier - 1);
                EffectHelper.addEffect(wearer, effect);
                PacketHandler.sendToAllTrackingPlayers(new CMessageEffect(wearer.m_19879_(), effect), wearer);
                persistantData.m_128356_(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
            }
        }
    }
}

