/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.gui.CustomButton;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageUpgradePerk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;

@OnlyIn(value=Dist.CLIENT)
public final class ScreenKnowledge
extends TBScreen {
    private static final ResourceLocation GUI_BAR = new ResourceLocation("minecraft", "textures/gui/bars.png");
    private static final ResourceLocation BOOK_PART = new ResourceLocation("tombstone", "textures/item/book_part1.png");
    private final LocalPlayer player;
    private final ITBCapability cap;
    private final int upgradableLevelMax;
    private final List<PerkIcon> icons = new ArrayList<PerkIcon>();
    private PerkIcon hoveredIcon;
    private int leftPerkPoints;
    private final ItemStack stackSkull = ItemAdvancement.IconType.FIRST_KNOWLEDGE.getItemStack();
    private final ItemStack stackRevive = ItemAdvancement.IconType.REVIVE.getItemStack();
    private final ItemStack stackAnkh = ItemAdvancement.IconType.FIRST_PRAY.getItemStack();
    private final double alignmentPos;
    private final List<BonusIcon> bonusIcons = new ArrayList<BonusIcon>();

    public ScreenKnowledge(LocalPlayer player, ITBCapability cap) {
        super((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]));
        this.player = player;
        this.cap = cap;
        this.upgradableLevelMax = EntityHelper.getPerkLevelMaxForKnowledge(cap.getTotalPerkPoints());
        PerkRegistry.get().getValues().forEach(perk -> this.icons.add(new PerkIcon((Perk)perk)));
        this.alignmentPos = this.getBarRatio();
        this.initBonusIcons(this.cap);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft + 15;
        int y = this.guiTop + 72;
        int i = 0;
        int spaceForIcon = 35;
        int maxIconByLine = 6;
        for (PerkIcon icon : this.icons) {
            int caseX = i % maxIconByLine;
            icon.setPosition(x + caseX * spaceForIcon, y);
            if (caseX == maxIconByLine - 1) {
                y += 40;
            }
            ++i;
        }
        int xIcon = this.guiLeft + 30;
        for (BonusIcon icon : this.bonusIcons) {
            icon.setPosition(xIcon, this.guiBottom - 45);
            xIcon += 18;
        }
        this.m_142416_((GuiEventListener)new CustomButton(this.guiLeft + 10, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_COMPENDIUM.getText(new Object[0]), pressable -> this.getMinecraft().m_91152_((Screen)new ScreenCompendium())));
        this.m_142416_((GuiEventListener)new CustomButton(this.guiRight - 10 - 70, this.guiBottom - 25, 70, 15, (Component)LangKey.MESSAGE_CONFIG.getText(new Object[0]), pressable -> this.getMinecraft().m_91152_((Screen)new ScreenConfig())));
    }

    private void initBonusIcons(ITBCapability cap) {
        ArrayList tooltips;
        int alignmentLevel;
        boolean isBad;
        TimeHelper.SpecialEvent specialEvent = TimeHelper.getSpecialEvent();
        if (specialEvent != TimeHelper.SpecialEvent.NONE) {
            String eventString = specialEvent == TimeHelper.SpecialEvent.CHRISTMAS ? "tombstone.advancement.christmas.title" : "tombstone.compendium." + (specialEvent == TimeHelper.SpecialEvent.HALLOWEEN ? "halloween" : "april_fools_day") + ".title";
            ItemStack icon = specialEvent == TimeHelper.SpecialEvent.CHRISTMAS ? new ItemStack((ItemLike)ModItems.christmas_gift) : ItemAdvancement.IconType.GHOST.getItemStack();
            this.bonusIcons.add(new BonusIcon(icon, Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)eventString).m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"tombstone.message.holiday_event_bonus")})));
        }
        if ((isBad = (alignmentLevel = cap.getAlignmentLevel()) < 0) || alignmentLevel > 0) {
            tooltips = new ArrayList();
            tooltips.add(Component.m_237115_((String)("tombstone.message." + (isBad ? "darkness" : "light"))).m_130940_(ChatFormatting.BOLD).m_130946_(" " + Math.abs(alignmentLevel)));
            tooltips.add(Component.m_237110_((String)"tombstone.message.protect_against", (Object[])new Object[]{Component.m_237115_((String)("tombstone.message." + (isBad ? "living_damages" : "undead_damages"))), Math.abs(alignmentLevel * 10)}));
            this.bonusIcons.add(new BonusIcon(isBad ? this.stackSkull : this.stackRevive, tooltips));
        }
        tooltips = isBad ? Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tombstone.advancement.zombify.title").m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"bonus.tombstone.zombify")}) : Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.exorcism.title").m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"bonus.tombstone.exorcism")});
        this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.EXORCISM.getItemStack(), tooltips));
        if (alignmentLevel > 0) {
            this.bonusIcons.add(new BonusIcon(ItemAdvancement.IconType.PRAY_OF_PROTECTION.getItemStack(), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"tombstone.advancement.pray_of_protection.title").m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"bonus.tombstone.pray_of_protection")})));
        }
        if (alignmentLevel > 1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.f_42655_), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_empathy.title").m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"bonus.tombstone.pray_of_empathy")})));
        }
        if (alignmentLevel < -1) {
            this.bonusIcons.add(new BonusIcon(new ItemStack((ItemLike)Items.f_42586_), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"bonus.tombstone.pray_of_undead.title").m_130940_(ChatFormatting.BOLD), Component.m_237115_((String)"bonus.tombstone.pray_of_undead")})));
        }
        this.bonusIcons.forEach(bonusIcon -> bonusIcon.tooltips.replaceAll(FontHelper::withFantasyFont));
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.hoveredIcon != null) {
            if (mouseButton == 0 && !this.hoveredIcon.perk.isDisabled((Player)this.player)) {
                int perkLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
                if (perkLevel < Math.min(this.hoveredIcon.perk.getLevelMax(), this.upgradableLevelMax) && this.leftPerkPoints >= this.hoveredIcon.perk.getCost(perkLevel + 1)) {
                    PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.UPGRADE_PERK, this.hoveredIcon.perk));
                    return true;
                }
            } else if (mouseButton == 1 && this.player.m_7500_() && this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk) > 0) {
                PacketHandler.sendToServer(new SMessageUpgradePerk(SMessageUpgradePerk.SyncType.DOWNGRADE_PERK, this.hoveredIcon.perk));
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.hoveredIcon = this.icons.stream().filter(p -> p.contains(mouseX, mouseY)).findFirst().orElse(null);
        int totalPerkPoints = this.cap.getTotalPerkPoints();
        int usedPerkPoints = this.cap.getUsedPerkPoints((Player)this.player);
        this.leftPerkPoints = totalPerkPoints - usedPerkPoints;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 4, -1);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 6, -1);
        FontHelper.drawCenteredFantasy(poseStack, this.f_96547_, (Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]), this.halfWidth, this.guiTop + 10, -1);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 20, -1);
        this.m_93154_(poseStack, this.guiLeft + 5, this.guiRight - 5, this.guiTop + 22, -1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BAR);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)40.0f, (int)182, (int)5, (int)182, (int)256);
        ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 30), (float)0.0f, (float)45.0f, (int)((int)(129.22 * (double)(this.cap.getKnowledge() - this.cap.getKnowledgeForLevel(totalPerkPoints)) / (double)this.cap.getKnowledgeForLevel(totalPerkPoints + 1))), (int)5, (int)182, (int)256);
        ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)(this.guiLeft + 52), (int)(this.guiTop + 31), (float)0.0f, (float)101.0f, (int)182, (int)3, (int)182, (int)256);
        int startAlignmentY = 44;
        FontHelper.drawCenteredFantasy(poseStack, this.f_96547_, (Component)LangKey.MESSAGE_ALIGNMENT.getText(new Object[0]), this.halfWidth, this.guiTop + startAlignmentY - 4, -1);
        ScreenKnowledge.m_93172_((PoseStack)poseStack, (int)(this.guiLeft + 20), (int)(this.guiTop + startAlignmentY + 10), (int)(this.guiRight - 20), (int)(this.guiTop + startAlignmentY + 17), (int)-16777216);
        Helper.fillGradient(matrix, this.guiLeft + 21, this.guiTop + startAlignmentY + 11, this.halfWidth, this.guiTop + startAlignmentY + 16, -65536, -1, this.m_93252_(), true);
        Helper.fillGradient(matrix, this.halfWidth, this.guiTop + startAlignmentY + 11, this.guiRight - 21, this.guiTop + startAlignmentY + 16, -1, -16776961, this.m_93252_(), true);
        Objects.requireNonNull(this);
        float step = (float)(230 - 42) / 8.0f;
        for (int i = 0; i < 8; ++i) {
            if (i == 4) continue;
            this.m_93222_(poseStack, this.guiLeft + 21 + (int)((float)i * step), this.guiTop + startAlignmentY + 10, this.guiTop + startAlignmentY + 16, -16777216);
        }
        this.f_96542_.m_115203_(this.stackSkull, this.guiLeft + 10, this.guiTop + startAlignmentY + 5);
        this.f_96542_.m_115203_(this.stackRevive, this.guiRight - 10 - 16, this.guiTop + startAlignmentY + 5);
        Objects.requireNonNull(this);
        int adjust = (int)Math.round((double)(230 - 42) / 2.0 * this.alignmentPos);
        this.f_96542_.m_115203_(this.stackAnkh, this.halfWidth + adjust - 8, this.guiTop + startAlignmentY + 4);
        String levelString = this.leftPerkPoints + " / " + totalPerkPoints;
        FontHelper.drawFantasy(poseStack, this.f_96547_, (Component)Component.m_237113_((String)levelString), this.guiLeft + 48 - this.f_96547_.m_92895_(levelString), this.guiTop + 28, -1);
        this.icons.forEach(icon -> this.drawPerk(poseStack, (PerkIcon)icon));
        this.bonusIcons.forEach(icon -> icon.render(poseStack));
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        if (this.hoveredIcon == null) {
            this.bonusIcons.stream().filter(icon -> icon.contains(mouseX, mouseY)).findFirst().ifPresent(icon -> this.renderComponentTooltip(poseStack, icon.tooltips, icon.minX + 10, icon.minY + 10, this.f_96547_));
        }
        this.drawPerkTooltip(poseStack);
    }

    private double getBarRatio() {
        boolean isPositive = this.cap.getAlignmentValue() >= 0;
        int alignment = Math.abs(Mth.m_14045_((int)this.cap.getAlignmentValue(), (int)this.cap.getAlignmentMinValue(), (int)this.cap.getAlignmentMaxValue()));
        double ratio = alignment > 300 ? 0.75 + 0.25 * (double)(alignment - 300) * 0.005 : (alignment > 150 ? 0.5 + 0.25 * (double)(alignment - 150) / 150.0 : (alignment > 50 ? 0.25 + 0.25 * (double)(alignment - 50) * 0.01 : 0.25 * (double)alignment * 0.02));
        return isPositive ? ratio : -ratio;
    }

    private void drawPerk(PoseStack poseStack, PerkIcon icon) {
        boolean isGray;
        int baseLevel = this.cap.getPerkLevel((Player)this.player, icon.perk);
        int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, icon.perk);
        boolean isHovered = icon.equals(this.hoveredIcon);
        boolean isMax = baseLevel == icon.perk.getLevelMax();
        boolean isDisabled = icon.perk.isDisabled((Player)this.player);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenKnowledge.m_93172_((PoseStack)poseStack, (int)icon.minX, (int)(icon.minY + 25 - 1), (int)(icon.maxX - 1), (int)icon.maxY, (int)-15329733);
        boolean bl = isGray = isDisabled || levelWithBonus == 0 && !isHovered;
        if (isGray) {
            RenderSystem.m_157429_((float)0.13f, (float)0.13f, (float)0.13f, (float)0.13f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)FRAME);
        ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)icon.minX, (int)icon.minY, (float)0.0f, (float)0.0f, (int)24, (int)24, (int)24, (int)24);
        RenderSystem.m_157456_((int)0, (ResourceLocation)icon.perk.getIcon());
        ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)(icon.minX + 2), (int)(icon.minY + 2), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
        if (icon.perk.equals(ModPerks.scribe)) {
            if (!isGray) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)BOOK_PART);
                RenderSystem.m_157429_((float)0.4117647f, (float)0.45882353f, (float)0.5176471f, (float)1.0f);
            }
            ScreenKnowledge.m_93133_((PoseStack)poseStack, (int)(icon.minX + 2), (int)(icon.minY + 2), (float)0.0f, (float)0.0f, (int)20, (int)20, (int)20, (int)20);
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isHovered) {
            int color = isDisabled ? -65536 : (isMax ? -1980292 : -7096363);
            this.m_93154_(poseStack, icon.minX - 1, icon.maxX - 1, icon.minY - 1, color);
            this.m_93154_(poseStack, icon.minX - 1, icon.maxX - 1, icon.maxY, color);
            this.m_93222_(poseStack, icon.minX - 1, icon.minY - 1, icon.maxY, color);
            this.m_93222_(poseStack, icon.maxX - 1, icon.minY - 1, icon.maxY, color);
        }
        boolean hasBonus = icon.perk.getLevelBonus((Player)this.player) != 0;
        MutableComponent perkLevelText = Component.m_237113_((String)("" + baseLevel)).m_6270_(isDisabled ? StyleType.COLOR_OFF : (isMax ? StyleType.PERK_TEXT_MAX : (baseLevel > 0 ? StyleType.PERK_TEXT_DEFAULT : StyleType.PERK_TEXT_DISABLE)));
        if (hasBonus && !isDisabled) {
            perkLevelText.m_7220_((Component)Component.m_237113_((String)("(" + levelWithBonus + ")")).m_130948_(StyleType.PERK_TEXT_BONUS));
        }
        FontHelper.drawCenteredFantasy(poseStack, this.f_96547_, (Component)perkLevelText, (float)(icon.minX + icon.maxX) / 2.0f, icon.maxY - 8, -1);
    }

    private void drawPerkTooltip(PoseStack poseStack) {
        if (this.hoveredIcon != null) {
            int baseLevel = this.cap.getPerkLevel((Player)this.player, this.hoveredIcon.perk);
            int levelWithBonus = this.cap.getPerkLevelWithBonus((Player)this.player, this.hoveredIcon.perk);
            int levelMax = this.hoveredIcon.perk.getLevelMax();
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(this.hoveredIcon.perk.getTranslation().m_6881_().m_130948_(StyleType.MESSAGE_SPECIAL));
            list.add(Component.m_237115_((String)(this.hoveredIcon.perk.getTranslationKey() + ".desc")).m_130940_(ChatFormatting.DARK_GRAY));
            list.add(LangKey.TOOLTIP_ACTUAL_BONUS.getText(new Object[0]).m_130948_(StyleType.INFO));
            ChatFormatting chatFormatting = levelWithBonus > baseLevel ? ChatFormatting.DARK_PURPLE : ChatFormatting.WHITE;
            this.hoveredIcon.perk.getCurrentBonusInfo(levelWithBonus).forEach(info -> list.add(info.m_6881_().m_130940_(chatFormatting)));
            if (this.hoveredIcon.perk.isDisabled((Player)this.player)) {
                list.add(Component.m_237115_((String)(this.hoveredIcon.perk.getTranslationKey() + ".disabled")).m_6270_(StyleType.COLOR_OFF));
            } else if (baseLevel < levelMax) {
                boolean canUpgradeLevel;
                int cost;
                if (levelWithBonus < levelMax) {
                    list.add(LangKey.TOOLTIP_NEXT_BONUS.getText(new Object[0]).m_130948_(StyleType.INFO));
                    this.hoveredIcon.perk.getNextBonusInfo(levelWithBonus + 1).forEach(info -> list.add(info.m_6881_().m_130940_(ChatFormatting.GRAY)));
                }
                boolean hasPerkPoints = this.leftPerkPoints >= (cost = this.hoveredIcon.perk.getCost(baseLevel + 1));
                list.add(LangKey.MESSAGE_COST.getText(hasPerkPoints ? ChatFormatting.AQUA : ChatFormatting.RED, new Object[]{cost}));
                boolean bl = canUpgradeLevel = baseLevel < this.upgradableLevelMax;
                if (!canUpgradeLevel) {
                    list.add(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(ChatFormatting.RED, new Object[0]).m_130946_(" " + EntityHelper.getKnowledgeForPerkLevel(baseLevel + 1)));
                }
                list.add(canUpgradeLevel && hasPerkPoints ? LangKey.MESSAGE_CLICK_TO_UPGRADE.getText(ChatFormatting.BLUE, new Object[0]) : LangKey.MESSAGE_CANT_UPGRADE.getText(ChatFormatting.RED, new Object[0]));
            } else {
                list.add(LangKey.MESSAGE_MAX.getText(ChatFormatting.GOLD, new Object[0]));
            }
            list.replaceAll(FontHelper::withFantasyFont);
            this.renderComponentTooltip(poseStack, list, this.hoveredIcon.minX + 17, this.hoveredIcon.minY, this.f_96547_);
        }
    }

    private static class PerkIcon {
        public static final int ICON_SIZE = 25;
        private final Perk perk;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        PerkIcon(Perk perk) {
            this.perk = perk;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 25;
            this.maxY = y + 25 + 10;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }
    }

    private class BonusIcon {
        public static final int ICON_SIZE = 16;
        private final ItemStack stack;
        private final List<Component> tooltips;
        private int minX;
        private int minY;
        private int maxX;
        private int maxY;

        BonusIcon(ItemStack stack, List<Component> tooltips) {
            this.stack = stack;
            this.tooltips = tooltips;
        }

        void setPosition(int x, int y) {
            this.minX = x;
            this.minY = y;
            this.maxX = x + 16;
            this.maxY = y + 16;
        }

        boolean contains(double mouseX, double mouseY) {
            return mouseX >= (double)this.minX && mouseY >= (double)this.minY && mouseX <= (double)this.maxX && mouseY <= (double)this.maxY;
        }

        private void render(PoseStack poseStack) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.minX - 1), (int)(this.minY - 1), (int)(this.maxX + 1), (int)(this.maxY + 1), (int)-15329733);
            ScreenKnowledge.this.m_93179_(poseStack, this.minX, this.minY, this.maxX, this.maxY, -16703669, -7096363);
            ScreenKnowledge.this.getMinecraft().m_91291_().m_115203_(this.stack, this.minX, this.minY);
        }
    }
}

