/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityDragonSurvival;
import ovh.corail.tombstone.compatibility.CompatibilityEnigmatic;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.item.ItemBook;

public final class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.m_122779_());

    public static void autoequip(ServerPlayer player, ItemStackHandler itemHandler) {
        Predicate<ItemStack> filter = InventoryHelper.getStackFilter(player);
        List<Integer> itemIds = IntStream.range(0, itemHandler.getSlots()).filter(i -> filter.test(itemHandler.getStackInSlot(i))).mapToObj(Integer.class::cast).collect(Collectors.toList());
        if (((Boolean)ConfigTombstone.compatibility.curioAutoEquip.get()).booleanValue() && SupportMods.CURIOS.isLoaded()) {
            CompatibilityCurio.instance.autoEquip(player, itemHandler, itemIds);
        }
        ListIterator idIterator = itemIds.listIterator(itemIds.size());
        while (idIterator.hasPrevious()) {
            int slotId = (Integer)idIterator.previous();
            if (!InventoryHelper.autoequip(itemHandler.getStackInSlot(slotId), player)) continue;
            itemHandler.setStackInSlot(slotId, ItemStack.f_41583_);
        }
    }

    private static Predicate<ItemStack> getStackFilter(ServerPlayer player) {
        Predicate<ItemStack> predic = stack -> !stack.m_41619_() && !EnchantmentHelper.m_44920_((ItemStack)stack);
        predic = SupportMods.CURIOS.isLoaded() && PlayerPreference.get(player).equipCurioSlotMagicBook() ? predic.and(stack -> stack.m_41720_() instanceof ItemBook || stack.m_41741_() == 1) : predic.and(stack -> stack.m_41741_() == 1);
        if (SupportMods.ENIGMATIC_LEGACY.isLoaded()) {
            predic = predic.and(stack -> !CompatibilityEnigmatic.instance.isDenied((ItemStack)stack));
        }
        if (SupportMods.POWERSUITS.isLoaded()) {
            predic = predic.and(stack -> !RegistryHelper.isValid(stack.m_41720_(), rl -> "powersuits".equals(rl.m_135827_())));
        }
        return predic;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean autoequip(ItemStack stack, ServerPlayer player) {
        boolean bl;
        if (player.m_21206_().m_41619_() && (stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK) || InventoryHelper.isBattleSign(stack))) {
            player.m_8061_(EquipmentSlot.OFFHAND, stack.m_41777_());
            return true;
        }
        if (SupportMods.SURVIVAL_DRAGON.isLoaded() && CompatibilityDragonSurvival.instance.autoEquip(stack, (Player)player)) {
            return true;
        }
        EquipmentSlot slot = stack.m_41720_().getEquipmentSlot(stack);
        boolean isElytra = false;
        if (slot == null) {
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                slot = armorItem.m_40402_();
            } else {
                if (!InventoryHelper.isElytra(stack)) return false;
                slot = EquipmentSlot.CHEST;
                isElytra = true;
            }
        } else if (slot == EquipmentSlot.CHEST) {
            isElytra = stack.m_41720_() instanceof ElytraItem;
        }
        int slotId = slot.m_20749_();
        ItemStack stackInSlot = (ItemStack)player.m_150109_().f_35975_.get(slotId);
        if (stackInSlot.m_41619_()) {
            player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
            return true;
        }
        if (slot != EquipmentSlot.CHEST) {
            return false;
        }
        boolean equipElytraInPriority = PlayerPreference.get(player).equipElytraInPriority();
        if (InventoryHelper.isElytra(stackInSlot)) {
            if (isElytra) return false;
            if (equipElytraInPriority) return false;
            bl = true;
        } else {
            if (!isElytra) return false;
            if (!equipElytraInPriority) return false;
            bl = true;
        }
        boolean canEquip = bl;
        if (!canEquip) return false;
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.m_41777_());
        player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
        return true;
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.m_41720_() instanceof ElytraItem || InventoryHelper.isWing(stack);
    }

    private static boolean isWing(ItemStack stack) {
        return SupportMods.WINGS.isLoaded() && RegistryHelper.isValid(stack.m_41720_(), rl -> SupportMods.WINGS.m_7912_().equals(rl.m_135827_()) && rl.m_135815_().endsWith("_wings"));
    }

    public static boolean isToolOrMelee(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41741_() == 1 && (stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof FishingRodItem || stack.m_41720_() instanceof ShearsItem || stack.m_41720_() instanceof TridentItem);
    }

    private static boolean isBattleSign(ItemStack stack) {
        return SupportMods.TCONSTRUCT.isLoaded() && RegistryHelper.isValid(stack.m_41720_(), rl -> "tconstruct".equals(rl.m_135827_()) && "battlesign".equals(rl.m_135815_()));
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return (IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static boolean removeFirstInInventory(Player player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).m_41619_() || ++found < count) continue;
            return true;
        }
        return false;
    }
}

