/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.combine.TooltipDyeable;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemSmokeBall
extends ItemGeneric {
    private TooltipComponent tooltip;

    public ItemSmokeBall() {
        super("smoke_ball", () -> SharedConfigTombstone.allowed_magic_items.allowSmokeBall.get());
        this.withDefaultInfo().withCombineInfo().withBetaInfo();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_150930_((Item)this)) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (Helper.RANDOM.nextFloat() * 0.4f + 0.8f));
            if (!level.f_46443_) {
                Snowball snowball = new Snowball(level, (LivingEntity)player);
                snowball.m_37446_(heldStack.m_41777_());
                snowball.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                level.m_7967_((Entity)snowball);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                heldStack.m_41774_(1);
            }
            return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return Optional.ofNullable(context.m_43723_()).map(player -> this.m_7203_(context.m_43725_(), (Player)player, context.m_43724_()).m_19089_()).orElse(InteractionResult.FAIL);
    }

    public int getColor(ItemStack stack, int tint) {
        return NBTStackHelper.getInteger(stack, "color", 0x808080);
    }

    public void setColor(ItemStack stack, int color) {
        int oldColor = NBTStackHelper.getInteger(stack, "color", -1);
        NBTStackHelper.setInteger(stack, "color", oldColor >= 0 ? Helper.combineColor(oldColor, color) : color);
    }

    public boolean m_142305_(ItemStack smokeBall, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        Item item;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.m_150651_(player) && smokeBall.m_150930_((Item)this) && (item = added.m_41720_()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (!player.f_19853_.m_5776_() || player.m_7500_()) {
                this.setColor(smokeBall, dyeItem.m_41089_().m_41070_());
                added.m_41774_(1);
                if (!player.m_7500_()) {
                    ModTriggers.COMBINE_IN_INVENTORY.trigger((ServerPlayer)player);
                    ModTriggers.COLOR_SMOKE_BALL.trigger((ServerPlayer)player);
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = new TooltipDyeable(stack, (result, dye) -> {
                this.setColor((ItemStack)result, dye.m_41089_().m_41070_());
                return result;
            });
        }
        return Optional.of(this.tooltip);
    }
}

