/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;

public class FluidHandlerItemCapacity
extends FluidHandlerItemStack
implements IFluidHandlerItemCapacity,
IFluidHandlerMutable,
INBTSerializable {
    private final Fluid fluid;

    public FluidHandlerItemCapacity(ItemStack container, int capacity) {
        this(container, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity);
        this.fluid = fluid;
    }

    public boolean canFillFluidType(FluidStack resource) {
        return this.fluid == null || resource == null || this.fluid == resource.getFluid();
    }

    @Override
    public void setCapacity(int capacity) {
        CompoundTag tag = this.getContainer().m_41784_();
        this.capacity = capacity;
        tag.m_128405_("capacity", capacity);
    }

    @Override
    public int getCapacity() {
        CompoundTag tag = this.getContainer().m_41784_();
        return tag.m_128425_("capacity", 3) ? tag.m_128451_("capacity") : this.capacity;
    }

    @Nullable
    public FluidStack getFluid() {
        this.capacity = this.getCapacity();
        return super.getFluid();
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == Capabilities.FLUID_HANDLER_ITEM_CAPACITY ? LazyOptional.of(() -> this).cast() : super.getCapability(capability, facing);
    }

    @Override
    public void setFluidInTank(int tank, FluidStack fluidStack) {
        if (tank == 0) {
            this.setFluid(fluidStack);
        }
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        FluidStack fluid = this.getFluid();
        if (fluid != null) {
            fluid.writeToNBT(nbt);
        } else {
            nbt.m_128359_("Empty", "");
        }
        nbt.m_128405_("capacity", this.getCapacity());
        return nbt;
    }

    public void deserializeNBT(Tag nbt) {
        CompoundTag tags = (CompoundTag)nbt;
        if (tags.m_128425_("capacity", 3)) {
            this.setCapacity(tags.m_128451_("capacity"));
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tags);
        this.setFluid(fluid);
    }
}

