/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.cyclops.cyclopscore.inventory.IValueNotifier;

public class ValueNotifierHelpers {
    public static String KEY = "v";

    public static void setValue(IValueNotifier notifier, int valueId, Tag value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, int value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, boolean value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, String value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, MutableComponent value) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(KEY, Component.Serializer.m_130703_((Component)value));
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, List<MutableComponent> values) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (Component component : values) {
            list.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component)));
        }
        tag.m_128365_(KEY, (Tag)list);
        notifier.setValue(valueId, tag);
    }

    @Nullable
    public static Tag getValueNbt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.m_128423_(KEY);
        }
        return null;
    }

    public static int getValueInt(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.m_128451_(KEY);
        }
        return 0;
    }

    public static boolean getValueBoolean(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.m_128471_(KEY);
        }
        return false;
    }

    @Nullable
    public static String getValueString(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.m_128461_(KEY);
        }
        return null;
    }

    @Nullable
    public static MutableComponent getValueTextComponent(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            return Component.Serializer.m_130701_((String)tag.m_128461_(KEY));
        }
        return null;
    }

    @Nullable
    public static List<MutableComponent> getValueTextComponentList(IValueNotifier notifier, int valueId) {
        CompoundTag tag = notifier.getValue(valueId);
        if (tag != null) {
            ListTag listTag = tag.m_128437_(KEY, 8);
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(Component.Serializer.m_130701_((String)listTag.m_128778_(i)));
            }
            return list;
        }
        return null;
    }
}

