/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDrawers
extends BlockItem {
    public ItemDrawers(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        MutableComponent textCapacity = Component.m_237110_((String)"tooltip.storagedrawers.drawers.capacity", (Object[])new Object[]{this.getCapacityForBlock(stack)});
        tooltip.add((Component)Component.m_237113_((String)"").m_7220_((Component)textCapacity).m_130940_(ChatFormatting.GRAY));
        CompoundTag tag = stack.m_41737_("tile");
        if (tag != null) {
            MutableComponent textSealed = Component.m_237115_((String)"tooltip.storagedrawers.drawers.sealed");
            tooltip.add((Component)Component.m_237113_((String)"").m_7220_((Component)textSealed).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public Component m_41466_() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }

    private int getCapacityForBlock(@NotNull ItemStack itemStack) {
        Block block = Block.m_49814_((Item)itemStack.m_41720_());
        if (block instanceof BlockDrawers) {
            BlockDrawers blockDrawers = (BlockDrawers)block;
            return blockDrawers.getStorageUnits() * CommonConfig.GENERAL.getBaseStackStorage();
        }
        return 0;
    }
}

