/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class GuiManaHUD
extends GuiComponent {
    public static final IGuiOverlay OVERLAY = GuiManaHUD::renderOverlay;
    private static final Minecraft minecraft = Minecraft.m_91087_();
    public static final Color BLACK = new Color(35, 35, 35).setImmutable();
    static boolean stillBar = true;

    public static boolean shouldDisplayBar() {
        IDisplayMana iDisplayManaOffhand;
        IDisplayMana iDisplayMana;
        ItemStack mainHand = GuiManaHUD.minecraft.f_91074_.m_21205_();
        ItemStack offHand = GuiManaHUD.minecraft.f_91074_.m_21206_();
        Item item = mainHand.m_41720_();
        return item instanceof IDisplayMana && (iDisplayMana = (IDisplayMana)item).shouldDisplay(mainHand) || (item = offHand.m_41720_()) instanceof IDisplayMana && (iDisplayManaOffhand = (IDisplayMana)item).shouldDisplay(offHand) || (double)ManaUtil.getMaxMana((Player)GuiManaHUD.minecraft.f_91074_) > ManaUtil.getCurrentMana((LivingEntity)GuiManaHUD.minecraft.f_91074_);
    }

    public static void renderOverlay(ForgeGui gui, PoseStack ms, float pt, int width, int height) {
        if (!GuiManaHUD.shouldDisplayBar()) {
            return;
        }
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)GuiManaHUD.minecraft.f_91074_).orElse(null);
        if (mana == null) {
            return;
        }
        int maxMana = mana.getMaxMana();
        if (maxMana == 0) {
            return;
        }
        int offsetLeft = 10 + (Integer)Config.MANABAR_X_OFFSET.get();
        int manaLength = 96;
        manaLength = (int)((double)manaLength * (mana.getCurrentMana() / ((double)maxMana * (1.0 + (double)ClientInfo.reservedOverlayMana))));
        int yOffset = minecraft.m_91268_().m_85446_() - 5 + (Integer)Config.MANABAR_Y_OFFSET.get();
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_border.png"));
        GuiManaHUD.m_93133_((PoseStack)ms, (int)offsetLeft, (int)(yOffset - 18), (float)0.0f, (float)0.0f, (int)108, (int)18, (int)256, (int)256);
        int manaOffset = (int)(((float)ClientInfo.ticksInGame + pt) / 3.0f % 33.0f) * 6;
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_mana.png"));
        GuiManaHUD.m_93133_((PoseStack)ms, (int)(offsetLeft + 9), (int)(yOffset - 9), (float)0.0f, (float)manaOffset, (int)manaLength, (int)6, (int)256, (int)256);
        GuiManaHUD.renderReserveOverlay(ms, offsetLeft, yOffset, manaOffset, maxMana);
        GuiManaHUD.renderRedOverlay(ms, offsetLeft, yOffset, manaOffset, maxMana);
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS) {
            String text = (int)mana.getCurrentMana() + "  /  " + maxMana;
            int maxWidth = GuiManaHUD.minecraft.f_91062_.m_92895_(maxMana + "  /  " + maxMana);
            int offset = 67 - maxWidth / 2 + (maxWidth - GuiManaHUD.minecraft.f_91062_.m_92895_(text));
            GuiManaHUD.m_93236_((PoseStack)ms, (Font)GuiManaHUD.minecraft.f_91062_, (String)text, (int)offset, (int)(yOffset - 10), (int)0xFFFFFF);
            GuiManaHUD.m_93236_((PoseStack)ms, (Font)GuiManaHUD.minecraft.f_91062_, (String)String.valueOf((int)(ClientInfo.reservedOverlayMana * (float)maxMana)), (int)(offset + 69), (int)(yOffset - 20), (int)0xFFFFFF);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_border.png"));
        GuiManaHUD.m_93133_((PoseStack)ms, (int)offsetLeft, (int)(yOffset - 17), (float)0.0f, (float)18.0f, (int)108, (int)20, (int)256, (int)256);
    }

    public static void renderRedOverlay(PoseStack ms, int offsetLeft, int yOffset, int manaOffset, int maxMana) {
        if (!ClientInfo.redTicks()) {
            return;
        }
        int redManaLength = (int)(98.0f * Mth.m_14036_((float)0.0f, (float)(ClientInfo.redOverlayMana / (float)maxMana), (float)1.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_grayscale.png"));
        RenderUtils.colorBlit(ms, offsetLeft + 8, yOffset - 10, 0, manaOffset, redManaLength, 8, 256, 256, Color.RED.scaleAlpha((float)ClientInfo.redOverlayTicks / 35.0f));
    }

    public static void renderReserveOverlay(PoseStack ms, int offsetLeft, int yOffset, int manaOffset, int maxMana) {
        if (ClientInfo.reservedOverlayMana <= 0.0f) {
            return;
        }
        int reserveManaLength = (int)(96.0f * ClientInfo.reservedOverlayMana);
        int offset = 96 - reserveManaLength;
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("ars_nouveau", "textures/gui/manabar_gui_mana.png"));
        RenderUtils.colorBlit(ms, offsetLeft + 10 + offset, yOffset - 10, 0, stillBar ? 0 : manaOffset, reserveManaLength, 8, 256, 256, BLACK);
    }
}

