/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import software.bernie.ars_nouveau.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.ars_nouveau.geckolib3.core.processor.IBone;
import software.bernie.ars_nouveau.geckolib3.model.AnimatedGeoModel;

public class RotatingTurretRenderer
extends ArsGeoBlockRenderer<RotatingTurretTile> {
    public static AnimatedGeoModel model = new GenericModel("basic_spell_turret"){

        @Override
        public void setCustomAnimations(Object animatable, int instanceId, AnimationEvent event) {
            if (animatable instanceof RotatingTurretTile) {
                RotatingTurretTile tile = (RotatingTurretTile)animatable;
                IBone master = this.getAnimationProcessor().getBone("spell_turret");
                master.setRotationY((tile.getRotationX() + 90.0f) * ((float)Math.PI / 180));
                master.setRotationX(tile.getRotationY() * ((float)Math.PI / 180));
            }
        }
    };

    public RotatingTurretRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, model);
    }

    @Override
    public void render(RotatingTurretTile tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float diff;
        super.render(tile, partialTick, poseStack, bufferSource, packedLight);
        float rotationX = tile.rotationX;
        float neededRotationX = tile.clientNeededX;
        float rotationY = tile.rotationY;
        float neededRotationY = tile.clientNeededY;
        float step = 0.1f + partialTick;
        if (rotationX != neededRotationX) {
            diff = neededRotationX - rotationX;
            if (Math.abs(diff) < step) {
                tile.setRotationX(neededRotationX);
            } else {
                tile.setRotationX(rotationX + diff * step);
            }
        }
        if (rotationY != neededRotationY) {
            diff = neededRotationY - rotationY;
            if (Math.abs(diff) < step) {
                tile.setRotationY(neededRotationY);
            } else {
                tile.setRotationY(rotationY + diff * step);
            }
        }
    }

    @Override
    protected void rotateBlock(Direction facing, PoseStack poseStack) {
    }
}

