/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.util.SummonUtil;
import com.hollingsworth.arsnouveau.common.entity.ModEntities;
import com.hollingsworth.arsnouveau.common.entity.goal.lily.WagGoal;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.ars_nouveau.geckolib3.core.IAnimatable;
import software.bernie.ars_nouveau.geckolib3.core.PlayState;
import software.bernie.ars_nouveau.geckolib3.core.builder.AnimationBuilder;
import software.bernie.ars_nouveau.geckolib3.core.controller.AnimationController;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationData;
import software.bernie.ars_nouveau.geckolib3.core.manager.AnimationFactory;
import software.bernie.ars_nouveau.geckolib3.util.GeckoLibUtil;

public class Lily
extends TamableAnimal
implements IAnimatable,
IDispellable {
    public static BiMap<UUID, UUID> ownerLilyMap = HashBiMap.create();
    private static final EntityDataAccessor<Boolean> SIT = SynchedEntityData.m_135353_(Lily.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAG = SynchedEntityData.m_135353_(Lily.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int wagTicks;
    AnimationFactory factory = GeckoLibUtil.createFactory(this);

    public Lily(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public Lily(Level level) {
        this((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.LILY.get()), level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WagGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (this.f_19853_.f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (this.m_21830_((LivingEntity)pPlayer)) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_8119_() {
        super.m_8119_();
        SummonUtil.healOverTime((LivingEntity)this);
        if (!this.f_19853_.f_46443_) {
            if (this.f_19853_.m_46467_() % 20L == 0L && !ownerLilyMap.containsValue((Object)this.m_20148_())) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.wagTicks > 0 && this.isWagging()) {
                --this.wagTicks;
                if (this.wagTicks <= 0) {
                    this.setWagging(false);
                }
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIT, (Object)false);
        this.f_19804_.m_135372_(WAG, (Object)false);
    }

    public boolean m_21827_() {
        return (Boolean)this.f_19804_.m_135370_(SIT);
    }

    public boolean m_21824_() {
        return true;
    }

    public void m_21839_(boolean pOrderedToSit) {
        this.f_19804_.m_135381_(SIT, (Object)pOrderedToSit);
    }

    public boolean isWagging() {
        return (Boolean)this.f_19804_.m_135370_(WAG);
    }

    public void setWagging(boolean pWagging) {
        this.f_19804_.m_135381_(WAG, (Object)pWagging);
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected SoundEvent m_7515_() {
        if (this.f_19796_.m_188503_(3) == 0) {
            return this.m_21824_() && this.m_21223_() < 10.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!(pSource.m_7639_() instanceof Player)) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6898_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public boolean isLookingAtMe(Player pPlayer) {
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && pPlayer.m_142582_((Entity)this);
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController<Lily>(this, "walk", 1.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("run"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.addAnimationController(new AnimationController<Lily>(this, "idle", 1.0f, event -> {
            if (!event.isMoving() && !this.isWagging()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.addAnimationController(new AnimationController<Lily>(this, "idle_wag", 1.0f, event -> {
            if (!event.isMoving() && this.isWagging()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("idle_wagging"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.addAnimationController(new AnimationController<Lily>(this, "rest", 1.0f, event -> {
            if (!event.isMoving() && this.m_21827_() && !this.isWagging()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("resting"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        data.addAnimationController(new AnimationController<Lily>(this, "rest_wag", 1.0f, event -> {
            if (!event.isMoving() && this.m_21827_() && this.isWagging()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("resting_wagging"));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean onDispel(@NotNull LivingEntity caster) {
        if (caster.m_20148_().equals(this.m_21805_())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public void m_20258_(CompoundTag pCompound) {
        super.m_20258_(pCompound);
        if (!ownerLilyMap.containsKey((Object)this.m_21805_())) {
            ownerLilyMap.put((Object)this.m_21805_(), (Object)this.m_20148_());
        }
    }
}

