/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import com.hollingsworth.arsnouveau.common.entity.pathfinding.ModNode;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.PathingConstants;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.pathjobs.AbstractPathJob;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor executor;

    public static ThreadPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, jobQueue, new MinecoloniesThreadFactory());
        }
        return executor;
    }

    public static void shutdown() {
        Pathfinding.getExecutor().shutdownNow();
        jobQueue.clear();
        executor = null;
    }

    private Pathfinding() {
    }

    public static void enqueue(AbstractPathJob job) {
        job.getResult().startJob(Pathfinding.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void debugDraw(double frame, PoseStack matrixStack) {
        Set<ModNode> debugNodesPath;
        Set<ModNode> debugNodesVisited;
        Set<ModNode> debugNodesNotVisited;
        if (AbstractPathJob.lastDebugNodesNotVisited == null) {
            return;
        }
        Vec3 vec = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
        double dx = vec.m_7096_();
        double dy = vec.m_7098_();
        double dz = vec.m_7094_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-dx, -dy, -dz);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69461_();
        Iterator<ModNode> iterator = PathingConstants.debugNodeMonitor;
        synchronized (iterator) {
            debugNodesNotVisited = AbstractPathJob.lastDebugNodesNotVisited;
            debugNodesVisited = AbstractPathJob.lastDebugNodesVisited;
            debugNodesPath = AbstractPathJob.lastDebugNodesPath;
        }
        try {
            for (ModNode n : debugNodesNotVisited) {
                Pathfinding.debugDrawNode(n, 1.0f, 0.0f, 0.0f, matrixStack);
            }
            for (ModNode n : debugNodesVisited) {
                Pathfinding.debugDrawNode(n, 0.0f, 0.0f, 1.0f, matrixStack);
            }
            for (ModNode n : debugNodesPath) {
                if (n.isReachedByWorker()) {
                    Pathfinding.debugDrawNode(n, 1.0f, 0.4f, 0.0f, matrixStack);
                    continue;
                }
                Pathfinding.debugDrawNode(n, 0.0f, 1.0f, 0.0f, matrixStack);
            }
        }
        catch (ConcurrentModificationException exc) {
            Log.getLogger().catching((Throwable)exc);
        }
        RenderSystem.m_69465_();
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void debugDrawNode(ModNode n, float r, float g, float b, PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)n.pos.m_123341_() + 0.375, (double)n.pos.m_123342_() + 0.375, (double)n.pos.m_123343_() + 0.375);
        Entity entity = Minecraft.m_91087_().m_91288_();
        double dx = (double)n.pos.m_123341_() - entity.m_20185_();
        double dy = (double)n.pos.m_123342_() - entity.m_20186_();
        double dz = (double)n.pos.m_123343_() - entity.m_20189_();
        if (Math.sqrt(dx * dx + dy * dy + dz * dz) <= 5.0) {
            Pathfinding.renderDebugText(n, matrixStack);
        }
        matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
        if (n.parent != null) {
            float pdx = (float)(n.parent.pos.m_123341_() - n.pos.m_123341_()) + 0.125f;
            float pdy = (float)(n.parent.pos.m_123342_() - n.pos.m_123342_()) + 0.125f;
            float pdz = (float)(n.parent.pos.m_123343_() - n.pos.m_123343_()) + 0.125f;
            vertexBuffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_85815_);
            vertexBuffer.m_85982_(matrix4f, 0.5f, 0.5f, 0.5f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
            vertexBuffer.m_85982_(matrix4f, pdx / 0.25f, pdy / 0.25f, pdz / 0.25f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
            tessellator.m_85914_();
        }
        matrixStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderDebugText(ModNode n, PoseStack matrixStack) {
        String s1 = String.format("F: %.3f [%d]", n.getCost(), n.getCounterAdded());
        String s2 = String.format("G: %.3f [%d]", n.getScore(), n.getCounterVisited());
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.75, 0.0);
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        matrixStack.m_85845_(renderManager.m_114470_());
        matrixStack.m_85841_(-0.014f, -0.014f, 0.014f);
        matrixStack.m_85837_(0.0, 18.0, 0.0);
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69472_();
        int i = Math.max(fontrenderer.m_92895_(s1), fontrenderer.m_92895_(s2)) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        vertexBuffer.m_85982_(matrix4f, (float)(-i - 1), -5.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(-i - 1), 12.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(i + 1), 12.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(i + 1), -5.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85837_(0.0, -5.0, 0.0);
        fontrenderer.m_92811_(s1, (float)(-fontrenderer.m_92895_(s1)) / 2.0f, 0.0f, -1, false, matrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        matrixStack.m_85837_(0.0, 8.0, 0.0);
        fontrenderer.m_92811_(s2, (float)(-fontrenderer.m_92895_(s2)) / 2.0f, 0.0f, -1, false, matrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        RenderSystem.m_69458_((boolean)true);
        matrixStack.m_85837_(0.0, -8.0, 0.0);
        fontrenderer.m_92811_(s1, (float)(-fontrenderer.m_92895_(s1)) / 2.0f, 0.0f, -1, false, matrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        matrixStack.m_85837_(0.0, 8.0, 0.0);
        fontrenderer.m_92811_(s2, (float)(-fontrenderer.m_92895_(s2)) / 2.0f, 0.0f, -1, false, matrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        buffer.m_109911_();
        matrixStack.m_85849_();
    }

    public static class MinecoloniesThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "AN stolen Minecolonies Pathfinding Worker #" + id++);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((thread1, throwable) -> Log.getLogger().error("AN stolen Minecolonies Pathfinding Thread errored! ", throwable));
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            return thread;
        }
    }
}

