/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.base.client.screen.BaseIcons;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompositeControl;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;

public class MachineStatusIndicator
extends AbstractCompositeControl
implements Consumer<Boolean> {
    private final Picture _statusOn;
    private final Picture _statusOff;

    public MachineStatusIndicator(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
        this._statusOn = new Picture(gui, "on", BaseIcons.MachineStatusOn);
        this._statusOff = new Picture(gui, "off", BaseIcons.MachineStatusOff);
        this._statusOn.setVisible(false);
        this._statusOff.setVisible(false);
        this.addChildControl(this._statusOn, this._statusOff);
    }

    public void updateStatus(boolean newStatus) {
        this._statusOn.setVisible(newStatus);
        this._statusOff.setVisible(!newStatus);
    }

    public void setTooltips(boolean status, List<Component> lines) {
        if (status) {
            this._statusOn.setTooltips(lines);
        } else {
            this._statusOff.setTooltips(lines);
        }
    }

    public void setTooltips(boolean status, String singleLineKey) {
        this.setTooltips(status, (List<Component>)ObjectLists.singleton((Object)Component.m_237115_((String)singleLineKey)));
    }

    public void setTooltips(boolean status, List<Component> lines, List<Object> objects) {
        if (status) {
            this._statusOn.setTooltips(lines, objects);
        } else {
            this._statusOff.setTooltips(lines, objects);
        }
    }

    @Override
    public void accept(Boolean active) {
        this.updateStatus(active);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        Rectangle statusRect = bounds.offset(-bounds.getX1(), -bounds.getY1());
        this._statusOn.setBounds(statusRect);
        this._statusOff.setBounds(statusRect);
    }
}

