/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

import it.zerono.mods.zerocore.base.redstone.sensor.ISensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.InputSensorAction;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.IMachineReader;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.NonNullPredicate;

public abstract class AbstractSensorSetting<Reader extends IMachineReader, Writer, SensorType extends ISensorType<Reader>>
implements NonNullPredicate<Reader>,
InputSensorAction<Writer> {
    public final SensorType Sensor;
    public final SensorBehavior Behavior;
    public final int Value1;
    public final int Value2;

    protected AbstractSensorSetting(SensorType sensor, SensorBehavior behavior, int v1, int v2) {
        this.Sensor = sensor;
        this.Behavior = behavior;
        this.Value1 = v1;
        this.Value2 = v2;
    }

    protected AbstractSensorSetting(CompoundTag data, Function<CompoundTag, SensorType> sensorTypeGetter) throws IllegalArgumentException {
        if (!(data.m_128441_("behavior") && data.m_128441_("v1") && data.m_128441_("v2"))) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        this.Sensor = (ISensorType)sensorTypeGetter.apply(data);
        this.Behavior = NBTHelper.nbtGetEnum(data, "behavior", SensorBehavior::valueOf, SensorBehavior.Disabled);
        this.Value1 = data.m_128451_("v1");
        this.Value2 = data.m_128451_("v2");
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        NBTHelper.nbtSetEnum(data, "behavior", this.Behavior);
        data.m_128405_("v1", this.Value1);
        data.m_128405_("v2", this.Value2);
        return data;
    }

    public boolean test(Reader reader) {
        return this.Sensor.isOutput() && this.Behavior.outputTest(this.Sensor.applyAsInt(reader), this.Value1, this.Value2);
    }
}

