/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.redstone.sensor;

public enum SensorBehavior {
    Disabled,
    SetFromSignal,
    SetFromSignalLevel,
    SetOnPulse,
    ToggleOnPulse,
    InsertOnPulse,
    RetractOnPulse,
    EjectOnPulse,
    ActiveWhileAbove,
    ActiveWhileBelow,
    ActiveWhileBetween;


    public boolean onPulse() {
        switch (this) {
            case SetOnPulse: 
            case ToggleOnPulse: 
            case InsertOnPulse: 
            case RetractOnPulse: 
            case EjectOnPulse: {
                return true;
            }
        }
        return false;
    }

    public boolean outputTest(int current, int v1, int v2) {
        switch (this) {
            case ActiveWhileAbove: {
                return current > v1;
            }
            case ActiveWhileBelow: {
                return current < v1;
            }
            case ActiveWhileBetween: {
                return current >= v1 && current <= v2;
            }
        }
        return false;
    }
}

