/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.client.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.debug.DebugHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class VoxelShapeHighlighter {
    private static final Colour COLOUR_SHAPE = Colour.from(DyeColor.YELLOW);
    private static final Colour COLOUR_RENDERSHAPE = Colour.from(DyeColor.RED);
    private static final Colour COLOUR_COLLISIONSHAPE = Colour.from(DyeColor.BLUE);
    private static final Colour COLOUR_RAYTRACESHAPE = Colour.from(DyeColor.PURPLE);

    @SubscribeEvent
    public static void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockPos position;
        BlockHitResult result = event.getTarget();
        if (HitResult.Type.BLOCK != result.m_6662_()) {
            return;
        }
        Level world = event.getCamera().m_90592_().m_20193_();
        DebugHelper.VoxelShapeType voxelType = DebugHelper.getBlockVoxelShapeHighlight(world, position = result.m_82425_());
        if (DebugHelper.VoxelShapeType.None == voxelType || !world.m_6857_().m_61937_(position)) {
            return;
        }
        BlockState blockstate = world.m_8055_(position);
        if (blockstate.m_60795_()) {
            return;
        }
        Camera renderInfo = event.getCamera();
        CollisionContext selection = CollisionContext.m_82750_((Entity)renderInfo.m_90592_());
        VertexConsumer builder = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        PoseStack matrixStack = event.getPoseStack();
        double x = (double)position.m_123341_() - renderInfo.m_90583_().m_7096_();
        double y = (double)position.m_123342_() - renderInfo.m_90583_().m_7098_();
        double z = (double)position.m_123343_() - renderInfo.m_90583_().m_7094_();
        switch (voxelType) {
            case General: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_SHAPE, blockstate.m_60651_((BlockGetter)world, position, selection));
                break;
            }
            case Render: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RENDERSHAPE, blockstate.m_60816_((BlockGetter)world, position));
                break;
            }
            case Collision: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_COLLISIONSHAPE, blockstate.m_60742_((BlockGetter)world, position, selection));
                break;
            }
            case RayTrace: {
                VoxelShapeHighlighter.paint(matrixStack, builder, x, y, z, COLOUR_RAYTRACESHAPE, blockstate.m_60771_((BlockGetter)world, position, CollisionContext.m_82749_()));
            }
        }
        event.setCanceled(true);
    }

    private static void paint(PoseStack matrixStack, VertexConsumer vertexBuilder, double originX, double originY, double originZ, Colour colour, VoxelShape voxelShape) {
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float red = colour.glRed();
        float green = colour.glGreen();
        float blue = colour.glBlue();
        voxelShape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            vertexBuilder.m_85982_(matrix, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, 0.5f).m_5752_();
            vertexBuilder.m_85982_(matrix, (float)(x2 + originX), (float)(y2 + originY), (float)(z2 + originZ)).m_85950_(red, green, blue, 0.5f).m_5752_();
        });
    }
}

