/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompoundControl;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControlContainer;
import it.zerono.mods.zerocore.lib.client.gui.control.Panel;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.data.EnumIndexedArray;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;

public class PanelGroup<Index extends Enum<Index>>
extends AbstractControlContainer {
    public IEvent<BiConsumer<Index, Panel>> PrePanelChange;
    public IEvent<BiConsumer<Index, Panel>> PostPanelChange;
    private final EnumIndexedArray<Index, Panel> _panels;
    private Index _activePanel;

    @SafeVarargs
    public PanelGroup(ModContainerScreen<? extends ModContainer> gui, String name, Index firstValidIndex, Index secondValidIndex, Index ... otherValidIndices) {
        this(gui, name, new EnumIndexedArray(Panel[]::new, firstValidIndex, secondValidIndex, otherValidIndices));
    }

    public PanelGroup(ModContainerScreen<? extends ModContainer> gui, String name, Index[] validIndices) {
        this(gui, name, new EnumIndexedArray((Function<Integer, Element[]>)((Function<Integer, Panel[]>)(Panel[]::new)), validIndices));
    }

    public PanelGroup(ModContainerScreen<? extends ModContainer> gui, String name, Iterable<Index> validIndices) {
        this(gui, name, new EnumIndexedArray(Panel[]::new, validIndices));
    }

    public Optional<Index> getActivePanelIndex() {
        return Optional.ofNullable(this._activePanel);
    }

    public Optional<Panel> getActivePanel() {
        return this.getActivePanelIndex().flatMap(this._panels::getElement);
    }

    public void setActivePanel(Index newIndex) {
        CodeHelper.optionalIfPresent(this.getActivePanelIndex(), this.getActivePanel(), (index, panel) -> this.PrePanelChange.raise(c -> c.accept(index, panel)));
        this._activePanel = newIndex;
        CodeHelper.optionalIfPresent(this.getActivePanelIndex(), this.getActivePanel(), (index, panel) -> this.PostPanelChange.raise(c -> c.accept(index, panel)));
    }

    public void clearActivePanel() {
        CodeHelper.optionalIfPresent(this.getActivePanelIndex(), this.getActivePanel(), (index, panel) -> this.PrePanelChange.raise(c -> c.accept(index, panel)));
        this._activePanel = null;
    }

    public void setPanel(Index index, Panel panel) {
        this._panels.setElement(index, panel);
    }

    public Optional<Panel> removePanel(Index index) {
        Optional<Panel> p = this._panels.getElement(index);
        if (p.isPresent()) {
            this._panels.setElement(index, null);
        }
        return p;
    }

    public void removeAllPanels() {
        this._panels.setAll(null);
    }

    public void removeAllPanels(Consumer<Panel> callback) {
        this._panels.stream().filter(Objects::nonNull).forEach(callback);
        this._panels.setAll(null);
    }

    @Override
    public Iterator<IControl> iterator() {
        return this.getActivePanel().map(AbstractCompoundControl::iterator).orElse(Collections.emptyIterator());
    }

    @Override
    public Optional<IControl> findControl(int x, int y) {
        return this.getActivePanel().flatMap(p -> p.findControl(x, y));
    }

    @Override
    public Optional<IControl> findControl(String name) {
        return this.getActivePanel().flatMap(p -> p.findControl(name));
    }

    @Override
    public boolean containsControl(IControl control) {
        return this.getActivePanel().map(p -> p.containsControl(control)).orElse(false);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this._panels.stream().forEach(p -> p.setBounds(bounds));
    }

    @Override
    public void translate(int xOffset, int yOffset) {
        this._panels.stream().forEach(p -> p.translate(xOffset, yOffset));
    }

    @Override
    public boolean onMouseMoved(IWindow wnd, int mouseX, int mouseY) {
        return this.getActivePanel().map(p -> p.onMouseMoved(wnd, mouseX, mouseY)).orElse(false);
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        return this.getActivePanel().map(p -> p.onMouseClicked(wnd, mouseX, mouseY, clickedButton)).orElse(false);
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        return this.getActivePanel().map(p -> p.onMouseClicked(wnd, mouseX, mouseY, releasedButton)).orElse(false);
    }

    @Override
    public boolean onMouseWheel(IWindow wnd, int mouseX, int mouseY, double movement) {
        return this.getActivePanel().map(p -> p.onMouseWheel(wnd, mouseX, mouseY, movement)).orElse(false);
    }

    @Override
    public void onPaintBackground(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getActivePanel().ifPresent(p -> p.onPaintBackground(matrix, partialTicks, mouseX, mouseY));
    }

    @Override
    public void onPaint(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getActivePanel().ifPresent(p -> p.onPaint(matrix, partialTicks, mouseX, mouseY));
    }

    @Override
    public void onPaintOverlay(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.getActivePanel().ifPresent(p -> p.onPaintOverlay(matrix, partialTicks, mouseX, mouseY));
    }

    @Override
    public void addControl(@Nonnull IControl control) {
        this.getActivePanel().ifPresent(p -> p.addControl(control));
    }

    @Override
    public void addControl(IControl ... controls) {
        this.getActivePanel().ifPresent(p -> p.addControl(controls));
    }

    @Override
    public void removeControl(@Nonnull IControl control) {
        this.getActivePanel().ifPresent(p -> p.removeControl(control));
    }

    @Override
    public void removeControls() {
        this.getActivePanel().ifPresent(AbstractControlContainer::removeControls);
    }

    @Override
    public int getControlsCount() {
        return this.getActivePanel().map(AbstractControlContainer::getControlsCount).orElse(0);
    }

    @Override
    public ILayoutEngine getLayoutEngine() {
        return this.getActivePanel().map(AbstractControlContainer::getLayoutEngine).orElse(cc -> {});
    }

    @Override
    public void setLayoutEngine(ILayoutEngine engine) {
        this.getActivePanel().ifPresent(p -> p.setLayoutEngine(engine));
    }

    @Override
    public void validate(Consumer<Component> errorReport) {
        this.getActivePanel().ifPresent(p -> p.validate(errorReport));
    }

    @Override
    protected void setControlOrigin(Point origin) {
        this._panels.stream().forEach(p -> p.setControlOrigin(origin));
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" indices:").append(this._panels.getValidIndices()).append(" active:").append(this.getActivePanel().map(Objects::toString).orElse(""));
    }

    private PanelGroup(ModContainerScreen<? extends ModContainer> gui, String name, EnumIndexedArray<Index, Panel> panels) {
        super(gui, name);
        this._panels = panels;
        this._activePanel = null;
        this.PrePanelChange = new Event<BiConsumer<Index, Panel>>();
        this.PostPanelChange = new Event<BiConsumer<Index, Panel>>();
    }
}

