/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.datagen.LootTableType;
import it.zerono.mods.zerocore.lib.datagen.provider.BaseLootTableProvider;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BaseBlockLootTableProvider
extends BaseLootTableProvider {
    protected BaseBlockLootTableProvider(DataGenerator dataGenerator) {
        super(LootTableType.Block, dataGenerator);
    }

    protected void addDrop(Supplier<? extends Block> block) {
        this.addDrop(block, block, 1);
    }

    @SafeVarargs
    protected final void addDrop(Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> block : blocks) {
            this.addDrop(block, block, 1);
        }
    }

    protected void addDrop(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop, int count) {
        this.addDrop(block.get(), (LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop.get()).m_79080_(ExplosionCondition.m_81661_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))));
    }

    protected void addSilkDrop(Supplier<? extends Block> block, Supplier<? extends ItemLike> standardDrop, int count, Supplier<? extends ItemLike> silkDrop) {
        this.addDrop(block.get(), (LootPoolEntryContainer.Builder<?>)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)silkDrop.get()).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)standardDrop.get()).m_79080_(ExplosionCondition.m_81661_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count)))}));
    }

    protected void addDrop(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop, int min, int max) {
        this.addDrop(block.get(), (LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop.get()).m_79080_(ExplosionCondition.m_81661_())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))));
    }

    protected void addSilkDrop(Supplier<? extends Block> block, Supplier<? extends ItemLike> standardDrop, int min, int max, Supplier<? extends ItemLike> silkDrop) {
        this.addDrop(block.get(), (LootPoolEntryContainer.Builder<?>)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)silkDrop.get()).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)standardDrop.get()).m_79080_(ExplosionCondition.m_81661_())).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max)))}));
    }

    private void addDrop(Block block, LootPoolEntryContainer.Builder<?> entry) {
        ResourceLocation id = CodeHelper.getObjectId(block);
        this.add(id, LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(id.m_135815_()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(entry)));
    }
}

