/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock;

import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class ReferencePartTracker<Controller extends IMultiblockController<Controller>>
implements Comparable<ReferencePartTracker<Controller>> {
    private IMultiblockPart<Controller> _part = null;

    public boolean isInvalid() {
        return null == this._part;
    }

    public void invalidate() {
        this._part = null;
    }

    @Nullable
    public IMultiblockPart<Controller> get() {
        return this._part;
    }

    public Optional<BlockPos> getPosition() {
        return null != this._part ? Optional.of(this._part.getWorldPosition()) : Optional.empty();
    }

    public void forfeitSaveDelegate() {
        if (null != this._part) {
            this._part.forfeitMultiblockSaveDelegate();
        }
    }

    public void accept(IMultiblockPart<Controller> part) {
        if (part.isPartInvalid() || part == this._part) {
            return;
        }
        if (null == this._part) {
            this._part = part;
            this._part.becomeMultiblockSaveDelegate();
        } else if (part.getWorldPosition().compareTo((Vec3i)this._part.getWorldPosition()) < 0) {
            this._part.forfeitMultiblockSaveDelegate();
            this._part = part;
            this._part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
    }

    public void accept(Iterable<IMultiblockPart<Controller>> parts) {
        BlockPos referencePosition = null;
        this.invalidate();
        for (IMultiblockPart<Controller> part : parts) {
            if (part.isPartInvalid()) continue;
            BlockPos partPosition = part.getWorldPosition();
            if (null != this._part && partPosition.compareTo(referencePosition) >= 0) continue;
            this._part = part;
            referencePosition = partPosition;
        }
        if (null != this._part) {
            this._part.becomeMultiblockSaveDelegate();
        }
    }

    public void consume(BiConsumer<IMultiblockPart<Controller>, BlockPos> consumer) {
        if (null != this._part) {
            consumer.accept(this._part, this._part.getWorldPosition());
        }
    }

    public boolean test(IMultiblockPart<Controller> other) {
        return this._part == other;
    }

    @Override
    public int compareTo(ReferencePartTracker<Controller> other) {
        if (other.isInvalid()) {
            return this.isInvalid() ? 0 : 1;
        }
        return this._part.getWorldPosition().compareTo((Vec3i)other._part.getWorldPosition());
    }
}

