/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.ingredient;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.item.ItemHelper;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.StrictNBTIngredient;

public abstract class ItemStackRecipeIngredient
implements IRecipeIngredient<ItemStack> {
    public static ItemStackRecipeIngredient from(Ingredient ingredient) {
        return ItemStackRecipeIngredient.from(ingredient, 1);
    }

    public static ItemStackRecipeIngredient from(Ingredient ingredient, int amount) {
        return new Impl(ingredient, amount);
    }

    public static ItemStackRecipeIngredient from(ItemStackRecipeIngredient ... ingredients) {
        return new CompositeImpl(ingredients);
    }

    public static ItemStackRecipeIngredient from(FriendlyByteBuf buffer) {
        int ingredientsCount = buffer.m_130242_();
        if (1 == ingredientsCount) {
            return new Impl(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130242_());
        }
        if (ingredientsCount > 1) {
            ItemStackRecipeIngredient[] ingredients = new ItemStackRecipeIngredient[ingredientsCount];
            for (int idx = 0; idx < ingredients.length; ++idx) {
                ingredients[idx] = new Impl(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130242_());
            }
            return new CompositeImpl(ingredients);
        }
        throw new IllegalArgumentException("Invalid item ingredient data from then network");
    }

    public static ItemStackRecipeIngredient from(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            JsonArray json = jsonElement.getAsJsonArray();
            int size = json.size();
            switch (size) {
                case 0: {
                    throw new JsonSyntaxException("No ingredients found, at least one is required");
                }
                case 1: {
                    return ItemStackRecipeIngredient.from(json.get(0));
                }
            }
            return ItemStackRecipeIngredient.from((ItemStackRecipeIngredient[])Streams.stream((Iterable)json).map(ItemStackRecipeIngredient::from).toArray(ItemStackRecipeIngredient[]::new));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            Ingredient ingredient = JSONHelper.jsonGetIngredient(json, "ingredient");
            int amount = JSONHelper.jsonGetInt(json, "count", 1);
            if (amount < 1) {
                throw new JsonSyntaxException("Ingredient amount must be larger than or equal to one");
            }
            return new Impl(ingredient, amount);
        }
        throw new JsonSyntaxException("Expected item ingredient entry to be object or array of objects");
    }

    public static ItemStackRecipeIngredient from(ItemStack stack) {
        return ItemStackRecipeIngredient.from(stack, stack.m_41613_());
    }

    public static ItemStackRecipeIngredient from(ItemStack stack, int amount) {
        return ItemStackRecipeIngredient.from((Ingredient)(stack.m_41782_() ? new StrictNBTIngredient(stack){} : Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack})), amount);
    }

    public static ItemStackRecipeIngredient from(ItemLike item) {
        return ItemStackRecipeIngredient.from(item, 1);
    }

    public static ItemStackRecipeIngredient from(ItemLike item, int amount) {
        return ItemStackRecipeIngredient.from(new ItemStack(item), amount);
    }

    public static ItemStackRecipeIngredient from(TagKey<Item> tag) {
        return ItemStackRecipeIngredient.from(tag, 1);
    }

    public static ItemStackRecipeIngredient from(TagKey<Item> tag, int amount) {
        return ItemStackRecipeIngredient.from(Ingredient.m_204132_(tag), amount);
    }

    static class Impl
    extends ItemStackRecipeIngredient {
        private final Ingredient _ingredient;
        private final int _amount;
        private List<ItemStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(ItemStack stack) {
            return this._ingredient.test(stack);
        }

        @Override
        public boolean isCompatible(ItemStack ... ingredients) {
            for (ItemStack stack : ingredients) {
                if (!this._ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ItemStack getMatchFrom(ItemStack stack) {
            return this.test(stack) ? ItemHelper.stackFrom(stack, this._amount) : ItemStack.f_41583_;
        }

        @Override
        public long getAmount(ItemStack stack) {
            return this.isCompatible(stack) ? (long)this._amount : 0L;
        }

        @Override
        public List<ItemStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)Arrays.stream(this._ingredient.m_43908_()).filter(stack -> !stack.m_41619_()).map(stack -> stack.m_41613_() == this._amount ? stack : ItemHelper.stackFrom(stack, this._amount)).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredient.m_43947_();
        }

        @Override
        public List<Ingredient> asVanillaIngredients() {
            return ObjectLists.singleton((Object)this._ingredient);
        }

        @Override
        public void serializeTo(FriendlyByteBuf buffer) {
            buffer.m_130130_(1);
            this._ingredient.m_43923_(buffer);
            buffer.m_130130_(this._amount);
        }

        @Override
        public JsonElement serializeTo() {
            JsonObject json = new JsonObject();
            JSONHelper.jsonSetIngredient(json, "ingredient", this._ingredient);
            JSONHelper.jsonSetInt(json, "count", this._amount);
            return json;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.isCompatible(stack) && this._amount <= stack.m_41613_();
        }

        @Override
        public boolean testIgnoreAmount(ItemStack stack) {
            return this.isCompatible(stack);
        }

        public String toString() {
            return this._amount + " " + Arrays.stream(this._ingredient.m_43908_()).map(stack -> stack.m_41720_().toString()).collect(Collectors.joining(","));
        }

        protected Impl(Ingredient ingredient, int amount) {
            this._ingredient = ingredient;
            this._amount = amount;
        }
    }

    static class CompositeImpl
    extends ItemStackRecipeIngredient {
        private final List<ItemStackRecipeIngredient> _ingredients;
        private List<ItemStack> _cachedMatchingElements;

        @Override
        public boolean isCompatible(ItemStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible(stack));
        }

        @Override
        public boolean isCompatible(ItemStack ... ingredients) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.isCompatible((T[])ingredients));
        }

        @Override
        public ItemStack getMatchFrom(ItemStack stack) {
            return this._ingredients.stream().map(ingredient -> ingredient.getMatchFrom(stack)).filter(match -> !match.m_41619_()).findAny().orElse(ItemStack.f_41583_);
        }

        @Override
        public long getAmount(ItemStack stack) {
            return this._ingredients.stream().mapToLong(ingredient -> ingredient.getAmount(stack)).filter(amount -> amount > 0L).findAny().orElse(0L);
        }

        @Override
        public List<ItemStack> getMatchingElements() {
            if (null == this._cachedMatchingElements) {
                this._cachedMatchingElements = (List)this._ingredients.stream().flatMap(ingredient -> ingredient.getMatchingElements().stream()).collect(ImmutableList.toImmutableList());
            }
            return this._cachedMatchingElements;
        }

        @Override
        public boolean isEmpty() {
            return this._ingredients.stream().anyMatch(IRecipeIngredient::isEmpty);
        }

        @Override
        public List<Ingredient> asVanillaIngredients() {
            return this.getMatchingElements().stream().map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).collect(Collectors.toList());
        }

        @Override
        public boolean test(ItemStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.test(stack));
        }

        @Override
        public boolean testIgnoreAmount(ItemStack stack) {
            return this._ingredients.stream().anyMatch(ingredient -> ingredient.testIgnoreAmount(stack));
        }

        @Override
        public void serializeTo(FriendlyByteBuf buffer) {
            buffer.m_130130_(this._ingredients.size());
            this._ingredients.forEach(ingredient -> ingredient.serializeTo(buffer));
        }

        @Override
        public JsonElement serializeTo() {
            JsonArray json = new JsonArray();
            this._ingredients.forEach(ingredient -> json.add(ingredient.serializeTo()));
            return json;
        }

        public String toString() {
            return this._ingredients.stream().map(Object::toString).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        }

        protected CompositeImpl(ItemStackRecipeIngredient[] ingredients) {
            this._ingredients = Lists.newArrayList((Object[])ingredients);
        }
    }
}

