/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiMergedTankGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiContainerEditModeTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class GuiDynamicTank
extends GuiMekanismTile<TileEntityDynamicTank, MekanismTileContainer<TileEntityDynamicTank>> {
    public GuiDynamicTank(MekanismTileContainer<TileEntityDynamicTank> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97731_ += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.addRenderableWidget(GuiSideHolder.armorHolder(this));
        this.addRenderableWidget(new GuiElementHolder(this, 141, 16, 26, 56));
        super.addGuiElements();
        this.addRenderableWidget(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 20));
        this.addRenderableWidget(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 50));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 49, 21, 84, 46, () -> {
            ArrayList<Component> ret = new ArrayList<Component>();
            TankMultiblockData multiblock = (TankMultiblockData)((TileEntityDynamicTank)this.tile).getMultiblock();
            long capacity = multiblock.getChemicalTankCapacity();
            switch (multiblock.mergedTank.getCurrentType()) {
                case EMPTY: {
                    ret.add((Component)MekanismLang.EMPTY.translate(new Object[0]));
                    break;
                }
                case FLUID: {
                    this.addStored(ret, multiblock.getFluidTank().getFluid(), FluidStack::getAmount);
                    capacity = multiblock.getTankCapacity();
                    break;
                }
                case GAS: {
                    this.addStored(ret, multiblock.getGasTank());
                    break;
                }
                case INFUSION: {
                    this.addStored(ret, multiblock.getInfusionTank());
                    break;
                }
                case PIGMENT: {
                    this.addStored(ret, multiblock.getPigmentTank());
                    break;
                }
                case SLURRY: {
                    this.addStored(ret, multiblock.getSlurryTank());
                }
            }
            ret.add((Component)MekanismLang.CAPACITY.translate(""));
            ret.add((Component)MekanismLang.GENERIC_MB.translate(TextUtils.format(capacity)));
            return ret;
        }).spacing(2));
        this.addRenderableWidget(new GuiDownArrow(this, 150, 39));
        this.addRenderableWidget(new GuiContainerEditModeTab<TileEntityDynamicTank>(this, (TileEntityDynamicTank)this.tile));
        this.addRenderableWidget(new GuiMergedTankGauge<TankMultiblockData>(() -> ((TankMultiblockData)((TileEntityDynamicTank)this.tile).getMultiblock()).mergedTank, ((TileEntityDynamicTank)this.tile)::getMultiblock, GaugeType.MEDIUM, this, 7, 16, 34, 56));
    }

    private void addStored(List<Component> ret, IChemicalTank<?, ?> tank) {
        this.addStored(ret, tank.getStack(), ChemicalStack::getAmount);
    }

    private <STACK> void addStored(List<Component> ret, STACK stack, ToLongFunction<STACK> amountGetter) {
        ret.add((Component)MekanismLang.GENERIC_PRE_COLON.translate(stack));
        ret.add((Component)MekanismLang.GENERIC_MB.translate(TextUtils.format(amountGetter.applyAsLong(stack))));
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

