/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiBar<INFO extends IBarInfoHandler>
extends GuiTexturedElement
implements ISupportsWarning<GuiBar<INFO>> {
    public static final ResourceLocation BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "base.png");
    private final INFO handler;
    protected final boolean horizontal;
    @Nullable
    private BooleanSupplier warningSupplier;

    public GuiBar(ResourceLocation resource, IGuiWrapper gui, INFO handler, int x, int y, int width, int height, boolean horizontal) {
        super(resource, gui, x, y, width + 2, height + 2);
        this.handler = handler;
        this.horizontal = horizontal;
    }

    @Override
    public GuiBar<INFO> warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    public INFO getHandler() {
        return this.handler;
    }

    @Override
    public void drawBackground(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        boolean warning;
        this.renderExtendedTexture(matrix, BAR, 2, 2);
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiSlot.WARNING_BACKGROUND_TEXTURE);
            GuiBar.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (float)0.0f, (float)0.0f, (int)(this.f_93618_ - 2), (int)(this.f_93619_ - 2), (int)256, (int)256);
        }
        this.drawContentsChecked(matrix, mouseX, mouseY, partialTicks, this.handler.getLevel(), warning);
    }

    void drawContentsChecked(@NotNull PoseStack matrix, int mouseX, int mouseY, float partialTicks, double handlerLevel, boolean warning) {
        if (handlerLevel > 0.0) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.getResource());
            this.renderBarOverlay(matrix, mouseX, mouseY, partialTicks, handlerLevel);
            if (warning && handlerLevel >= 0.98) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)WARNING_TEXTURE);
                if (this.horizontal) {
                    int halfHeight = (this.f_93619_ - 2) / 2;
                    GuiBar.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1 + halfHeight), (float)0.0f, (float)halfHeight, (int)(this.f_93618_ - 2), (int)halfHeight, (int)256, (int)256);
                } else {
                    int halfWidth = (this.f_93618_ - 2) / 2;
                    GuiBar.m_93133_((PoseStack)matrix, (int)(this.f_93620_ + 1 + halfWidth), (int)(this.f_93621_ + 1), (float)halfWidth, (float)0.0f, (int)halfWidth, (int)(this.f_93619_ - 2), (int)256, (int)256);
                }
            }
        }
    }

    protected abstract void renderBarOverlay(PoseStack var1, int var2, int var3, float var4, double var5);

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        Component tooltip = this.handler.getTooltip();
        if (tooltip != null) {
            this.displayTooltips(matrix, mouseX, mouseY, tooltip);
        }
    }

    protected static int calculateScaled(double scale, int value) {
        if (scale == 1.0) {
            return value;
        }
        if (scale < 1.0) {
            return (int)(scale * (double)value);
        }
        return (int)Math.round(scale * (double)value);
    }

    public static interface IBarInfoHandler {
        @Nullable
        default public Component getTooltip() {
            return null;
        }

        public double getLevel();
    }
}

