/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.client.gui.element.button.RadioButton;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

class BooleanToggle
extends MiniElement {
    private static final int RADIO_SIZE = 8;
    private final ModuleConfigItem<Boolean> data;

    BooleanToggle(GuiModuleScreen parent, ModuleConfigItem<Boolean> data, int xPos, int yPos, int dataIndex) {
        super(parent, xPos, yPos, dataIndex);
        this.data = data;
    }

    @Override
    protected int getNeededHeight() {
        return 20;
    }

    @Override
    protected void renderBackground(PoseStack matrix, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)RadioButton.RADIO);
        this.drawRadio(matrix, mouseX, mouseY, this.data.get(), 4, 11, 0);
        this.drawRadio(matrix, mouseX, mouseY, this.data.get() == false, 50, 11, 8);
    }

    private void drawRadio(PoseStack matrix, int mouseX, int mouseY, boolean selected, int relativeX, int relativeY, int selectedU) {
        if (selected) {
            GuiComponent.m_93133_((PoseStack)matrix, (int)(this.getX() + relativeX), (int)(this.getY() + relativeY), (float)selectedU, (float)8.0f, (int)8, (int)8, (int)16, (int)16);
        } else {
            boolean hovered = this.mouseOver(mouseX, mouseY, relativeX, relativeY, 8, 8);
            GuiComponent.m_93133_((PoseStack)matrix, (int)(this.getX() + relativeX), (int)(this.getY() + relativeY), (float)(hovered ? 8.0f : 0.0f), (float)0.0f, (int)8, (int)8, (int)16, (int)16);
        }
    }

    @Override
    protected void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        this.parent.drawTextWithScale(matrix, this.data.getDescription(), this.getRelativeX() + 3, this.getRelativeY(), textColor, 0.8f);
        this.parent.drawTextWithScale(matrix, (Component)MekanismLang.TRUE.translate(new Object[0]), this.getRelativeX() + 16, this.getRelativeY() + 11, textColor, 0.8f);
        this.parent.drawTextWithScale(matrix, (Component)MekanismLang.FALSE.translate(new Object[0]), this.getRelativeX() + 62, this.getRelativeY() + 11, textColor, 0.8f);
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (this.data.get().booleanValue()) {
            if (this.mouseOver(mouseX, mouseY, 50, 11, 8, 8)) {
                this.setDataFromClick(false);
            }
        } else if (this.mouseOver(mouseX, mouseY, 4, 11, 8, 8)) {
            this.setDataFromClick(true);
        }
    }

    private void setDataFromClick(boolean value) {
        this.setData(this.data, value);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
    }
}

