/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiVisualsTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MinerEnergyContainer;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.ThreadMinerSearch;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.to_server.PacketGuiButtonPress;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.interfaces.IHasVisualization;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiDigitalMiner
extends GuiMekanismTile<TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private static final ResourceLocation EJECT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/eject.png");
    private static final ResourceLocation INPUT = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/input.png");
    private static final ResourceLocation SILK = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/silk.png");
    private MekanismButton startButton;
    private MekanismButton stopButton;
    private MekanismButton configButton;

    public GuiDigitalMiner(MekanismTileContainer<TileEntityDigitalMiner> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97727_ += 76;
        this.f_97731_ = this.f_97727_ - 94;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 7, 19, 77, 69, () -> {
            ArrayList<Object> list = new ArrayList<Object>();
            MekanismLang runningType = ((TileEntityDigitalMiner)this.tile).getEnergyContainer().getEnergyPerTick().greaterThan(((TileEntityDigitalMiner)this.tile).getEnergyContainer().getMaxEnergy()) ? MekanismLang.MINER_LOW_POWER : (((TileEntityDigitalMiner)this.tile).isRunning() ? MekanismLang.MINER_RUNNING : MekanismLang.IDLE);
            list.add(runningType.translate(new Object[0]));
            list.add(((TileEntityDigitalMiner)this.tile).searcher.state.getTextComponent());
            list.add(MekanismLang.MINER_TO_MINE.translate(TextUtils.format(((TileEntityDigitalMiner)this.tile).getToMine())));
            return list;
        }).spacing(1).clearFormat());
        this.addRenderableWidget(new GuiDigitalSwitch(this, 19, 56, EJECT, ((TileEntityDigitalMiner)this.tile)::getDoEject, (Component)MekanismLang.AUTO_EJECT.translate(new Object[0]), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_EJECT_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.addRenderableWidget(new GuiDigitalSwitch(this, 38, 56, INPUT, ((TileEntityDigitalMiner)this.tile)::getDoPull, (Component)MekanismLang.AUTO_PULL.translate(new Object[0]), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.AUTO_PULL_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.addRenderableWidget(new GuiDigitalSwitch(this, 57, 56, SILK, ((TileEntityDigitalMiner)this.tile)::getSilkTouch, (Component)MekanismLang.MINER_SILK.translate(new Object[0]), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SILK_TOUCH_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LOWER_ICON));
        this.addRenderableWidget(new GuiVerticalPowerBar((IGuiWrapper)this, ((TileEntityDigitalMiner)this.tile).getEnergyContainer(), 157, 39, 47)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, () -> {
            MinerEnergyContainer energyContainer = ((TileEntityDigitalMiner)this.tile).getEnergyContainer();
            return energyContainer.getEnergyPerTick().greaterThan(energyContainer.getEnergy());
        });
        this.addRenderableWidget(new GuiVisualsTab(this, (IHasVisualization)((Object)this.tile)));
        this.addRenderableWidget(new GuiSlot(SlotType.DIGITAL, this, 64, 21).setRenderAboveSlots().validity(() -> ((TileEntityDigitalMiner)this.tile).missingStack).with(() -> ((TileEntityDigitalMiner)this.tile).missingStack.m_41619_() ? SlotOverlay.CHECK : null).hover(this.getOnHover(() -> ((TileEntityDigitalMiner)this.tile).missingStack.m_41619_() ? MekanismLang.MINER_WELL.translate(new Object[0]) : MekanismLang.MINER_MISSING_BLOCK.translate(new Object[0]))));
        this.addRenderableWidget(new GuiEnergyTab(this, () -> {
            MinerEnergyContainer energyContainer = ((TileEntityDigitalMiner)this.tile).getEnergyContainer();
            return List.of(MekanismLang.MINER_ENERGY_CAPACITY.translate(EnergyDisplay.of(energyContainer.getMaxEnergy())), MekanismLang.NEEDED_PER_TICK.translate(EnergyDisplay.of(energyContainer.getEnergyPerTick())), MekanismLang.MINER_BUFFER_FREE.translate(EnergyDisplay.of(energyContainer.getNeeded())));
        }));
        int buttonStart = 19;
        this.startButton = this.addRenderableWidget(new TranslationButton(this, 87, buttonStart, 61, 18, MekanismLang.BUTTON_START, () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.START_BUTTON, this.tile))));
        this.stopButton = this.addRenderableWidget(new TranslationButton(this, 87, buttonStart + 17, 61, 18, MekanismLang.BUTTON_STOP, () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STOP_BUTTON, this.tile))));
        this.configButton = this.addRenderableWidget(new TranslationButton(this, 87, buttonStart + 34, 61, 18, MekanismLang.BUTTON_CONFIG, () -> Mekanism.packetHandler().sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DIGITAL_MINER_CONFIG, this.tile))));
        this.addRenderableWidget(new TranslationButton(this, 87, buttonStart + 51, 61, 18, MekanismLang.MINER_RESET, () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.RESET_BUTTON, this.tile))));
        this.updateEnabledButtons();
        this.trackWarning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, () -> ((TileEntityDigitalMiner)this.tile).getFilterManager().anyEnabledMatch(MinerFilter::hasBlacklistedElement));
        this.trackWarning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT_OVERFLOW, ((TileEntityDigitalMiner)this.tile)::hasOverflow);
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.startButton.f_93623_ = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE || !((TileEntityDigitalMiner)this.tile).isRunning();
        this.stopButton.f_93623_ = ((TileEntityDigitalMiner)this.tile).searcher.state != ThreadMinerSearch.State.IDLE && ((TileEntityDigitalMiner)this.tile).isRunning();
        this.configButton.f_93623_ = ((TileEntityDigitalMiner)this.tile).searcher.state == ThreadMinerSearch.State.IDLE;
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

