/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.energycube;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mekanism.api.RelativeSide;
import mekanism.client.model.energycube.EnergyCubeBakedModel;
import mekanism.client.render.lib.QuadTransformation;
import mekanism.client.render.lib.QuadUtils;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class EnergyCubeGeometry
implements IUnbakedGeometry<EnergyCubeGeometry> {
    private final List<BlockElement> frame;
    private final Map<RelativeSide, List<BlockElement>> leds;
    private final Map<RelativeSide, List<BlockElement>> ports;

    EnergyCubeGeometry(List<BlockElement> frame, Map<RelativeSide, List<BlockElement>> leds, Map<RelativeSide, List<BlockElement>> ports) {
        this.frame = frame;
        this.leds = leds;
        this.ports = ports;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite particle = spriteGetter.apply(context.getMaterial("particle"));
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint == null ? RenderTypeGroup.EMPTY : context.getRenderType(renderTypeHint);
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = new SimpleModelState(modelState.m_6189_().m_121096_(rootTransform), modelState.m_7538_());
        }
        Function<String, TextureAtlasSprite> rawSpriteGetter = spriteGetter.compose(arg_0 -> ((IGeometryBakingContext)context).getMaterial(arg_0));
        FaceData frame = this.bakeElement(rawSpriteGetter, modelState, modelLocation, this.frame);
        Map<RelativeSide, FaceData> leds = this.bakeElements(rawSpriteGetter, modelState, modelLocation, this.leds);
        Map<RelativeSide, FaceData> ports = this.bakeElements(rawSpriteGetter, modelState, modelLocation, this.ports);
        return new EnergyCubeBakedModel(context.useAmbientOcclusion(), context.useBlockLight(), context.isGui3d(), context.getTransforms(), overrides, particle, frame, leds, ports, renderTypes);
    }

    private Map<RelativeSide, FaceData> bakeElements(Function<String, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation, Map<RelativeSide, List<BlockElement>> sideBasedElements) {
        EnumMap<RelativeSide, FaceData> sideBasedFaceData = new EnumMap<RelativeSide, FaceData>(RelativeSide.class);
        for (Map.Entry<RelativeSide, List<BlockElement>> entry : sideBasedElements.entrySet()) {
            FaceData faceData = this.bakeElement(spriteGetter, modelState, modelLocation, entry.getValue());
            sideBasedFaceData.put(entry.getKey(), faceData);
        }
        return sideBasedFaceData;
    }

    private FaceData bakeElement(Function<String, TextureAtlasSprite> spriteGetter, ModelState modelState, ResourceLocation modelLocation, List<BlockElement> elements) {
        FaceData data = new FaceData();
        for (BlockElement element : elements) {
            for (Map.Entry faceEntry : element.f_111310_.entrySet()) {
                BlockElementFace face = (BlockElementFace)faceEntry.getValue();
                TextureAtlasSprite sprite = spriteGetter.apply(face.f_111356_);
                Direction direction = face.f_111354_ == null ? null : modelState.m_6189_().rotateTransform(face.f_111354_);
                data.addFace(direction, BlockModel.m_111437_((BlockElement)element, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)((Direction)faceEntry.getKey()), (ModelState)modelState, (ResourceLocation)modelLocation));
            }
        }
        return data;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<Material> textures = new HashSet<Material>();
        if (context.hasMaterial("particle")) {
            textures.add(context.getMaterial("particle"));
        }
        this.addMaterials(context, missingTextureErrors, this.frame, textures);
        for (List<BlockElement> elements : this.leds.values()) {
            this.addMaterials(context, missingTextureErrors, elements, textures);
        }
        for (List<BlockElement> elements : this.ports.values()) {
            this.addMaterials(context, missingTextureErrors, elements, textures);
        }
        return textures;
    }

    private void addMaterials(IGeometryBakingContext context, Set<Pair<String, String>> missingTextureErrors, List<BlockElement> elements, Set<Material> textures) {
        for (BlockElement part : elements) {
            for (BlockElementFace face : part.f_111310_.values()) {
                Material texture = context.getMaterial(face.f_111356_);
                if (texture.m_119203_().equals((Object)MissingTextureAtlasSprite.m_118071_())) {
                    missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)context.getModelName()));
                }
                textures.add(texture);
            }
        }
    }

    static class FaceData {
        private List<BakedQuad> unculledFaces;
        private Map<Direction, List<BakedQuad>> culledFaces;

        FaceData() {
        }

        public List<BakedQuad> getFaces(@Nullable Direction side) {
            if (side == null) {
                return this.unculledFaces == null ? Collections.emptyList() : this.unculledFaces;
            }
            return this.culledFaces == null ? Collections.emptyList() : this.culledFaces.getOrDefault(side, Collections.emptyList());
        }

        public void addFace(@Nullable Direction direction, BakedQuad quad) {
            List quads;
            if (direction == null) {
                if (this.unculledFaces == null) {
                    this.unculledFaces = new ArrayList<BakedQuad>();
                }
                quads = this.unculledFaces;
            } else {
                if (this.culledFaces == null) {
                    this.culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
                }
                quads = this.culledFaces.computeIfAbsent(direction, dir -> new ArrayList());
            }
            quads.add((BakedQuad)quad);
        }

        public FaceData transform(QuadTransformation transformation) {
            if (this.unculledFaces == null && this.culledFaces == null) {
                return this;
            }
            FaceData transformed = new FaceData();
            if (this.unculledFaces != null) {
                transformed.unculledFaces = QuadUtils.transformBakedQuads(this.unculledFaces, transformation);
            }
            if (this.culledFaces != null) {
                transformed.culledFaces = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
                for (Map.Entry<Direction, List<BakedQuad>> entry : this.culledFaces.entrySet()) {
                    transformed.culledFaces.put(entry.getKey(), QuadUtils.transformBakedQuads(entry.getValue(), transformation));
                }
            }
            return transformed;
        }
    }
}

